/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.worker.example;

import com.hpe.caf.api.Codec;
import com.hpe.caf.api.worker.DataStore;
import com.hpe.caf.api.worker.DataStoreException;
import com.hpe.caf.api.worker.DataStoreSource;
import com.hpe.caf.api.worker.InvalidTaskException;
import com.hpe.caf.api.worker.TaskRejectedException;
import com.hpe.caf.api.worker.WorkerResponse;
import com.hpe.caf.util.ref.DataSource;
import com.hpe.caf.util.ref.DataSourceException;
import com.hpe.caf.util.ref.ReferencedData;
import com.hpe.caf.worker.AbstractWorker;
import com.hpe.caf.worker.example.ExampleWorkerAction;
import com.hpe.caf.worker.example.ExampleWorkerResult;
import com.hpe.caf.worker.example.ExampleWorkerStatus;
import com.hpe.caf.worker.example.ExampleWorkerTask;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExampleWorker
extends AbstractWorker<ExampleWorkerTask, ExampleWorkerResult> {
    private static final Logger LOG = LoggerFactory.getLogger(ExampleWorker.class);
    private final DataStore dataStore;
    private final long resultSizeThreshold;

    public ExampleWorker(ExampleWorkerTask task, DataStore dataStore, String outputQueue, Codec codec, long resultSizeThreshold) throws InvalidTaskException {
        super((Object)task, outputQueue, codec);
        this.dataStore = Objects.requireNonNull(dataStore);
        this.resultSizeThreshold = resultSizeThreshold;
    }

    public String getWorkerIdentifier() {
        return "ExampleWorker";
    }

    public int getWorkerApiVersion() {
        return 1;
    }

    public WorkerResponse doWork() throws InterruptedException, TaskRejectedException {
        ExampleWorkerResult result = this.processFile();
        if (result.workerStatus == ExampleWorkerStatus.COMPLETED) {
            return this.createSuccessResult(result);
        }
        return this.createFailureResult(result);
    }

    private ExampleWorkerResult processFile() throws InterruptedException {
        LOG.info("Starting work");
        this.checkIfInterrupted();
        DataStoreSource source = new DataStoreSource(this.dataStore, this.getCodec());
        ReferencedData data = ((ExampleWorkerTask)this.getTask()).sourceData;
        try {
            InputStream textStream = data.acquire((DataSource)source);
            String original = IOUtils.toString((InputStream)textStream, (Charset)StandardCharsets.UTF_8);
            String result = "";
            if (((ExampleWorkerTask)this.getTask()).action == ExampleWorkerAction.REVERSE) {
                for (int i = original.length() - 1; i >= 0; --i) {
                    result = result + original.charAt(i);
                }
            } else if (((ExampleWorkerTask)this.getTask()).action == ExampleWorkerAction.CAPITALISE) {
                result = original.toUpperCase();
            } else if (((ExampleWorkerTask)this.getTask()).action == ExampleWorkerAction.VERBATIM) {
                result = original;
            }
            ReferencedData textDataSource = this.wrapAsReferencedData(result.getBytes());
            ExampleWorkerResult workerResult = new ExampleWorkerResult();
            workerResult.workerStatus = ExampleWorkerStatus.COMPLETED;
            workerResult.textData = textDataSource;
            return workerResult;
        }
        catch (DataSourceException e) {
            LOG.warn("Error acquiring data", (Throwable)e);
            return this.createErrorResult(ExampleWorkerStatus.SOURCE_FAILED);
        }
        catch (DataStoreException e) {
            LOG.warn("Error storing result", (Throwable)e);
            return this.createErrorResult(ExampleWorkerStatus.STORE_FAILED);
        }
        catch (IOException e) {
            LOG.warn("Error converting input stream to text", (Throwable)e);
            return this.createErrorResult(ExampleWorkerStatus.WORKER_EXAMPLE_FAILED);
        }
    }

    private ExampleWorkerResult createErrorResult(ExampleWorkerStatus status) {
        ExampleWorkerResult workerResult = new ExampleWorkerResult();
        workerResult.workerStatus = status;
        return workerResult;
    }

    private ReferencedData wrapAsReferencedData(byte[] data) throws DataSourceException, DataStoreException {
        ReferencedData refData;
        if ((long)data.length > this.resultSizeThreshold) {
            String ref = this.dataStore.store((InputStream)new ByteArrayInputStream(data), ((ExampleWorkerTask)this.getTask()).datastorePartialReference);
            refData = ReferencedData.getReferencedData((String)ref);
        } else {
            refData = ReferencedData.getWrappedData((byte[])data);
        }
        return refData;
    }
}

