/*
 * Decompiled with CFR 0.152.
 */
package com.github.writethemfirst.approvals;

import com.github.writethemfirst.approvals.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;

public class ApprobationContext {
    private final Path folder;
    private final String methodName;

    public ApprobationContext(Path folder, String methodName) {
        this.folder = folder;
        this.methodName = methodName;
    }

    public void writeApproved(String content) {
        Path approvedFile = this.approvedFile();
        FileUtils.write(content, approvedFile);
    }

    public void writeApproved(String content, Path relativeFile) {
        Path approvedFile = this.approvedFile(relativeFile);
        FileUtils.write(content, approvedFile);
    }

    public void writeReceived(String content, Path relativeFile) {
        Path receivedFile = this.receivedFile(relativeFile);
        FileUtils.write(content, receivedFile);
    }

    public String readApproved(Path relativeFile) {
        return FileUtils.silentRead(this.approvedFile(relativeFile));
    }

    public void removeApproved(Path relativeFile) {
        FileUtils.silentRemove(this.approvedFile(relativeFile));
    }

    public void removeReceived(Path relativeFile) {
        FileUtils.silentRemove(this.receivedFile(relativeFile));
    }

    public Path approvedFile(Path relativeFile) {
        return this.approvedFolder().resolve(relativeFile + ".approved");
    }

    public Path receivedFile(Path relativeFile) {
        return this.approvedFolder().resolve(relativeFile + ".received");
    }

    public String readApproved() {
        return FileUtils.silentRead(this.approvedFile());
    }

    public void removeApproved() {
        FileUtils.silentRemove(this.approvedFile());
    }

    public void writeReceived(String content) {
        Path receivedFile = this.receivedFile();
        FileUtils.write(content, receivedFile);
    }

    public String readReceived() {
        return FileUtils.silentRead(this.receivedFile());
    }

    public void removeReceived() {
        FileUtils.silentRemove(this.receivedFile());
    }

    public void createEmptyApprovedFileIfEmpty() {
        File approvedFile = this.approvedFile().toFile();
        if (!approvedFile.exists()) {
            try {
                approvedFile.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Could not create empty approved file <%s>", approvedFile), e);
            }
        }
    }

    List<Path> approvedFilesInFolder() {
        int MAX_DEPTH = 5;
        BiPredicate<Path, BasicFileAttributes> approvedExtension = (path, attributes) -> attributes.isRegularFile() && path.toString().endsWith(".approved");
        Path approvedFolder = this.approvedFolder();
        try {
            Files.createDirectories(approvedFolder, new FileAttribute[0]);
            return Files.find(approvedFolder, MAX_DEPTH, approvedExtension, new FileVisitOption[0]).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("cannot browse %s for approved files", approvedFolder), e);
        }
    }

    Path approvedFile() {
        String fileName = String.format("%s.approved", this.methodName);
        return this.folder.resolve(fileName);
    }

    Path receivedFile() {
        String fileName = String.format("%s.received", this.methodName);
        return this.folder.resolve(fileName);
    }

    Path approvedFolder() {
        String folderName = String.format("%s.Files", this.methodName);
        return this.folder.resolve(folderName);
    }
}

