/*
 * Decompiled with CFR 0.152.
 */
package com.github.writethemfirst.approvals;

import com.github.writethemfirst.approvals.ApprobationContext;
import com.github.writethemfirst.approvals.ApprovalsFiles;
import com.github.writethemfirst.approvals.ApprovedAndReceived;
import com.github.writethemfirst.approvals.Reporter;
import com.github.writethemfirst.approvals.reporters.ThrowsReporter;
import com.github.writethemfirst.approvals.reporters.softwares.Generic;
import com.github.writethemfirst.approvals.utils.FileUtils;
import com.github.writethemfirst.approvals.utils.StackUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Approvals {
    private final ApprovalsFiles approvalsFiles;
    private final Reporter reporter;

    public Approvals() {
        this(Generic.DEFAULT);
    }

    public Approvals(Reporter reporter) {
        this(StackUtils.callerClass(Approvals.class), reporter);
    }

    public Approvals(Class<?> clazz) {
        this(clazz, Generic.DEFAULT);
    }

    public Approvals(Class<?> clazz, Reporter reporter) {
        this.approvalsFiles = new ApprovalsFiles(clazz);
        this.reporter = reporter;
    }

    public void verify(Object output) {
        this.verify(output, this.approvalsFiles.defaultContext());
    }

    public void verify(Object output, String methodName) {
        this.verify(output, this.approvalsFiles.context(methodName));
    }

    private void verify(Object output, ApprobationContext context) {
        if (this.matchesApprovedFile(output, context)) {
            context.removeReceived();
        } else {
            context.createEmptyApprovedFileIfEmpty();
            this.reporter.mismatch(context.approvedFile(), context.receivedFile());
            new ThrowsReporter().mismatch(context.approvedFile(), context.receivedFile());
        }
    }

    private boolean matchesApprovedFile(Object output, ApprobationContext context) {
        String approvedContent = context.readApproved();
        context.writeReceived(output.toString());
        return approvedContent != null && approvedContent.equals(output.toString());
    }

    public void verifyAgainstMasterFolder(Path actualFolder) {
        ApprobationContext context = this.approvalsFiles.defaultContext();
        Path approvedFolder = context.approvedFolder();
        Map<Boolean, List<ApprovedAndReceived>> matchesAndMismatches = context.approvedFilesInFolder().stream().map(approvedFile -> this.approvedAndReceived(actualFolder, approvedFolder, (Path)approvedFile)).collect(Collectors.partitioningBy(ar -> ar.haveSameContent()));
        matchesAndMismatches.get(true).forEach(ar -> FileUtils.silentRemove(ar.receivedFile));
        this.handleMismatches(matchesAndMismatches.get(false));
    }

    private void handleMismatches(List<ApprovedAndReceived> mismatches) {
        mismatches.forEach(mismatch -> this.reporter.mismatch(mismatch.approvedFile, mismatch.receivedFile));
        mismatches.forEach(mismatch -> new ThrowsReporter().mismatch(mismatch.approvedFile, mismatch.receivedFile));
    }

    private ApprovedAndReceived approvedAndReceived(Path actualFolder, Path approvedFolder, Path approvedFile) {
        Path approvedRelative = approvedFolder.relativize(approvedFile);
        Path simplePath = Paths.get(approvedRelative.toString().replace(".approved", ""), new String[0]);
        Path actualFile = actualFolder.resolve(simplePath);
        Path receivedFile = approvedFolder.resolve(simplePath + ".received");
        FileUtils.copy(actualFile, receivedFile);
        return new ApprovedAndReceived(approvedFile, receivedFile);
    }
}

