/*
 * Decompiled with CFR 0.152.
 */
package com.github.writethemfirst.approvals.reporters;

import com.github.writethemfirst.approvals.Reporter;
import java.nio.file.Path;
import java.util.Optional;

public class FirstWorkingReporter
implements Reporter {
    private final Reporter[] reporters;
    private Optional<Reporter> firstAvailable;

    public FirstWorkingReporter(Reporter ... reporters) {
        this.reporters = reporters;
    }

    @Override
    public void mismatch(Path approved, Path received) {
        if (this.firstAvailable().isPresent()) {
            this.firstAvailable().get().mismatch(approved, received);
        }
    }

    @Override
    public boolean isAvailable() {
        return this.firstAvailable().isPresent();
    }

    private Optional<Reporter> firstAvailable() {
        boolean firstTime;
        boolean bl = firstTime = this.firstAvailable == null;
        if (firstTime) {
            this.firstAvailable = this.findFirstAvailable();
        }
        return this.firstAvailable;
    }

    private Optional<Reporter> findFirstAvailable() {
        for (Reporter reporter : this.reporters) {
            if (!reporter.isAvailable()) continue;
            return Optional.of(reporter);
        }
        return Optional.empty();
    }
}

