/*
 * Decompiled with CFR 0.152.
 */
package com.github.writethemfirst.approvals.reporters;

import com.github.writethemfirst.approvals.Reporter;
import com.github.writethemfirst.approvals.utils.FileUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;

public class JUnit5Reporter
implements Reporter {
    private final String JUNIT5_ASSERTIONS = "org.junit.jupiter.api.Assertions";

    @Override
    public void mismatch(Path approved, Path received) {
        try {
            Class<?> testCaseClass = Class.forName("org.junit.jupiter.api.Assertions");
            Method assertEquals = testCaseClass.getMethod("assertEquals", Object.class, Object.class, String.class);
            assertEquals.invoke(null, FileUtils.silentRead(approved), FileUtils.silentRead(received), String.format("%s differs from %s", received, approved));
        }
        catch (InvocationTargetException e) {
            throw (AssertionError)((Object)e.getCause());
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isAvailable() {
        try {
            Class.forName("org.junit.jupiter.api.Assertions");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

