/*
 * Decompiled with CFR 0.152.
 */
package com.github.writethemfirst.approvals.reporters.commands;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class Command {
    private static final int MAX_FOLDERS_DEPTH = 5;
    static String WINDOWS_ENV_PROGRAM_FILES = "ProgramFiles";
    static String WINDOWS_ENV_PROGRAM_FILES_X86 = "ProgramFiles(x86)";
    public static final String PROGRAM_FILES_KEY = "%programFiles%";
    private final Runtime runtime;
    private final Map<String, String> env;
    private final String path;
    private final String executable;
    private Optional<String> cachedLatestPath;
    private final String programFilesFolder;
    private final String programFilesX86Folder;

    public Command(String path, String executable) {
        this(path, executable, Runtime.getRuntime(), System.getenv());
    }

    Command(String path, String executable, Runtime runtime, Map<String, String> env) {
        this.path = path;
        this.executable = executable;
        this.runtime = runtime;
        this.env = env;
        this.programFilesFolder = env.get(WINDOWS_ENV_PROGRAM_FILES);
        this.programFilesX86Folder = env.get(WINDOWS_ENV_PROGRAM_FILES_X86);
    }

    public void execute(String ... arguments) throws IOException {
        String[] cmdArray = (String[])Stream.concat(Stream.of(this.pathToLatestExe().get()), Arrays.stream(arguments)).toArray(String[]::new);
        this.runtime.exec(cmdArray);
    }

    public boolean isAvailable() {
        return this.pathToLatestExe().isPresent();
    }

    Optional<String> pathToLatestExe() {
        if (this.cachedLatestPath == null) {
            this.cachedLatestPath = this.searchForExe();
        }
        return this.cachedLatestPath;
    }

    private Optional<String> searchForExe() {
        Stream<Path> programFilesFolders = Stream.concat(this.replaced(this.programFilesFolder), this.replaced(this.programFilesX86Folder));
        Stream<Path> possiblePaths = Stream.concat(programFilesFolders, this.notReplaced());
        return possiblePaths.flatMap(this::matchingCommandInPath).map(Path::toString).max(Comparator.naturalOrder());
    }

    private Stream<Path> matchingCommandInPath(Path possiblePath) {
        try {
            return Files.find(possiblePath, 5, (p, a) -> p.endsWith(this.executable), FileVisitOption.FOLLOW_LINKS);
        }
        catch (IOException e) {
            System.err.println(e);
            return Stream.empty();
        }
    }

    private Stream<Path> replaced(String folder) {
        if (folder == null) {
            return Stream.empty();
        }
        Path path = Paths.get(this.path.replace(PROGRAM_FILES_KEY, folder), new String[0]);
        return path.toFile().isDirectory() ? Stream.of(path) : Stream.empty();
    }

    private Stream<Path> notReplaced() {
        if (this.path.contains(PROGRAM_FILES_KEY)) {
            return Stream.empty();
        }
        Path pat = Paths.get(this.path, new String[0]);
        return pat.toFile().isDirectory() ? Stream.of(pat) : Stream.empty();
    }
}

