/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sql2java;

import net.sourceforge.sql2java.Column;
import net.sourceforge.sql2java.Table;

public final class StringUtilities {
    private static StringUtilities singleton = new StringUtilities();
    public static final String PREFIX = "";
    public static final String BASE_SUFFIX = "";
    public static final String MANAGER_SUFFIX = "Manager";
    public static final String BEAN_SUFFIX = "";
    public static final String RELATIONNAL_BEAN_SUFFIX = "Relationnal_Bean";
    public static final String ITERATOR_SUFFIX = "Iterator";
    public static final String FACTORY_SUFFIX = "Factory";
    public static final String EXCEPTION_SUFFIX = "Exception";
    static String[] reserved_words = new String[]{"null", "true", "false", "abstract", "double", "int", "strictfp", "boolean", "else", "interface", "super", "break", "extends", "long", "switch", "byte", "final", "native", "synchronized", "case", "finally", "new", "this", "catch", "float", "package", "throw", "char", "for", "private", "throws", "class", "goto", "protected", "transient", "const", "if", "public", "try", "continue", "implements", "return", "void", "default", "import", "short", "volatile", "do", "instanceof", "static", "while", "assert"};

    private StringUtilities() {
    }

    public static synchronized StringUtilities getInstance() {
        return singleton;
    }

    public String getPackageAsPath(String pkg) {
        if (pkg == null) {
            return "";
        }
        return pkg.replace('.', '/');
    }

    public String getDefaultRules(Column col) {
        return col.getDefaultRules();
    }

    public String getPropertyTag(Column col) {
        return col.getPropertyTag();
    }

    public String convertClass(String table, String type) {
        String suffix = "";
        String postfix = "";
        if (!"".equalsIgnoreCase("")) {
            suffix = suffix + "_";
        }
        if (!"".equalsIgnoreCase(type)) {
            postfix = "_" + type;
        }
        return this.convertName(suffix + table + postfix);
    }

    public String getCoreClass(Table table) {
        return this.convertClass(table.getName(), "");
    }

    public String getCoreClass(String table) {
        return this.convertClass(table, "");
    }

    public String getBeanClass(Table table) {
        return this.convertClass(table.getName(), "");
    }

    public String getBeanClass(String table) {
        return this.convertClass(table, "");
    }

    public String getRelationnalBeanClass(Table table) {
        return this.convertClass(table.getName(), RELATIONNAL_BEAN_SUFFIX);
    }

    public String getRelationnalBeanClass(String table) {
        return this.convertClass(table, RELATIONNAL_BEAN_SUFFIX);
    }

    public String getFactoryClass(Table table) {
        return this.convertClass(table.getName(), FACTORY_SUFFIX);
    }

    public String getFactoryClass(String table) {
        return this.convertClass(table, FACTORY_SUFFIX);
    }

    public String getExceptionClass(Table table) {
        return this.convertClass(table.getName(), EXCEPTION_SUFFIX);
    }

    public String getExceptionClass(String table) {
        return this.convertClass(table, EXCEPTION_SUFFIX);
    }

    public String getIteratorClass(Table table) {
        return this.convertClass(table.getName(), ITERATOR_SUFFIX);
    }

    public String getIteratorClass(String table) {
        return this.convertClass(table, ITERATOR_SUFFIX);
    }

    public String getManagerClass(Table table) {
        return this.convertClass(table.getName(), MANAGER_SUFFIX);
    }

    public String getManagerClass(String table) {
        return this.convertClass(table, MANAGER_SUFFIX);
    }

    public String getManagerObjectName(Table table) {
        return this.getManagerObjectName(table.getName());
    }

    public String getManagerObjectName(String table) {
        String objName = this.convertClass(table, MANAGER_SUFFIX);
        char f = Character.toLowerCase(objName.charAt(0));
        return Character.toString(f) + objName.substring(1);
    }

    public String getStringConvertionMethod(Column col) {
        return col.getStringConvertionMethod();
    }

    public String getGetMethod(Column col) {
        return this.getGetMethod(col.getName());
    }

    public String getSetMethod(Column col) {
        return this.getSetMethod(col.getName());
    }

    public String getModifiedMethod(Column col) {
        return this.getModifiedMethod(col.getName());
    }

    public String getInitializedMethod(Column col) {
        return this.getInitializedMethod(col.getName());
    }

    public String getWidgetMethod(Column col) {
        return this.getWidgetMethod(col.getName());
    }

    public String getGetMethod(String col) {
        return StringUtilities.convertName("get_" + this.escape(col), true);
    }

    public String getSetMethod(String col) {
        return StringUtilities.convertName("set_" + this.escape(col), true);
    }

    public String getModifiedMethod(String col) {
        return StringUtilities.convertName("is_" + this.escape(col) + "_modified", true);
    }

    public String getInitializedMethod(String col) {
        return StringUtilities.convertName("is_" + this.escape(col) + "_initialized", true);
    }

    public String getWidgetMethod(String col) {
        return StringUtilities.convertName("get_" + this.escape(col) + "_widget", true);
    }

    public String getVarName(Column c) {
        return StringUtilities.convertName(this.escape(c), true);
    }

    public String getVarName(String c) {
        return StringUtilities.convertName(this.escape(c), true);
    }

    public String getModifiedVarName(Column c) {
        return this.getVarName(c) + "_is_modified";
    }

    public String getInitializedVarName(Column c) {
        return this.getVarName(c) + "_is_initialized";
    }

    public String getForeignKeyVarName(Column c) {
        return StringUtilities.convertName(this.escape(c) + "_object", true);
    }

    public String getForeignKeyModifiedVarName(Column c) {
        return this.getVarName(c) + "_object_is_modified";
    }

    public String getForeignKeyInitializedVarName(Column c) {
        return this.getVarName(c) + "_object_is_initialized";
    }

    public String getForeignKeyInitializedMethod(Column col) {
        return StringUtilities.convertName("is_" + this.escape(col) + "_object_initialized", true);
    }

    public String getForeignKeyGetMethod(Column col) {
        return StringUtilities.convertName("get_" + this.escape(col) + "_object", true);
    }

    public String getForeignKeySetMethod(Column col) {
        return StringUtilities.convertName("set_" + this.escape(col) + "_object", true);
    }

    public String getForeignKeyModifiedMethod(Column col) {
        return StringUtilities.convertName("is_" + this.escape(col) + "_object_modified", true);
    }

    public String getForeignKeyVarName(String col) {
        return StringUtilities.convertName(this.escape(col) + "_object", true);
    }

    public String getForeignKeyModifiedVarName(String c) {
        return this.getVarName(c) + "_object_is_modified";
    }

    public String getForeignKeyInitializedVarName(String c) {
        return this.getVarName(c) + "_object_is_initialized";
    }

    public String getForeignKeyInitializedMethod(String col) {
        return StringUtilities.convertName("is_" + this.escape(col) + "_object_initialized", true);
    }

    public String getForeignKeyGetMethod(String col) {
        return StringUtilities.convertName("get_" + this.escape(col) + "_object", true);
    }

    public String getForeignKeySetMethod(String col) {
        return StringUtilities.convertName("set_" + this.escape(col) + "_object", true);
    }

    public String getForeignKeyModifiedMethod(String col) {
        return StringUtilities.convertName("is_" + this.escape(col) + "_object_modified", true);
    }

    public String getImportedKeyVarName(Column c) {
        return StringUtilities.convertName(this.escape(c) + "_collection", true);
    }

    public String getImportedKeyModifiedVarName(Column c) {
        return this.getVarName(c) + "_collection_is_modified";
    }

    public String getImportedKeyInitializedVarName(Column c) {
        return this.getVarName(c) + "_collection_is_initialized";
    }

    public String getImportedKeyInitializedMethod(Column col) {
        return StringUtilities.convertName("is_" + this.escape(col) + "_collection_initialized", true);
    }

    public String getImportedKeyGetMethod(Column col) {
        return StringUtilities.convertName("get_" + this.escape(col) + "_collection", true);
    }

    public String getImportedKeyAddMethod(Column col) {
        return StringUtilities.convertName("add_" + this.escape(col) + "", true);
    }

    public String getImportedKeySetMethod(Column col) {
        return StringUtilities.convertName("set_" + this.escape(col) + "_collection", true);
    }

    public String getImportedKeyModifiedMethod(Column col) {
        return StringUtilities.convertName("is_" + this.escape(col) + "_collection_modified", true);
    }

    public String getImportedKeyVarName(String col) {
        return StringUtilities.convertName(this.escape(col) + "_collection", true);
    }

    public String getImportedKeyModifiedVarName(String c) {
        return this.getVarName(c) + "_collection_is_modified";
    }

    public String getImportedKeyInitializedVarName(String c) {
        return this.getVarName(c) + "_collection_is_initialized";
    }

    public String getImportedKeyInitializedMethod(String col) {
        return StringUtilities.convertName("is_" + this.escape(col) + "_collection_initialized", true);
    }

    public String getImportedKeyGetMethod(String col) {
        return StringUtilities.convertName("get_" + this.escape(col) + "_collection", true);
    }

    public String getImportedKeyAddMethod(String col) {
        return StringUtilities.convertName("add_" + this.escape(col) + "", true);
    }

    public String getImportedKeySetMethod(String col) {
        return StringUtilities.convertName("set_" + this.escape(col) + "_collection", true);
    }

    public String getImportedKeyModifiedMethod(String col) {
        return StringUtilities.convertName("is_" + this.escape(col) + "_collection_modified", true);
    }

    public String getJavaPrimaryType(Column c) {
        try {
            return c.getJavaPrimaryType();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String convertName(String name) {
        return StringUtilities.convertName(name, false);
    }

    public String convertName(Column col) {
        return StringUtilities.convertName(col.getName(), false);
    }

    public String convertName(Table table) {
        return StringUtilities.convertName(table.getName(), false);
    }

    public static String convertName(String name, boolean wimpyCaps) {
        StringBuffer buffer = new StringBuffer(name.length());
        char[] list = name.toLowerCase().toCharArray();
        for (int i = 0; i < list.length; ++i) {
            if (i == 0 && !wimpyCaps) {
                buffer.append(Character.toUpperCase(list[i]));
                continue;
            }
            if (list[i] == '_' && i + 1 < list.length && i != 0) {
                buffer.append(Character.toUpperCase(list[++i]));
                continue;
            }
            buffer.append(list[i]);
        }
        return buffer.toString();
    }

    private String escape(String s) {
        return this.isReserved(s) ? "my_" + s : s;
    }

    private String escape(Column s) {
        return this.isReserved(s.getName()) ? "my_" + s.getName() : s.getName();
    }

    boolean isReserved(String s) {
        for (int i = 0; i < reserved_words.length; ++i) {
            if (s.compareToIgnoreCase(reserved_words[i]) != 0) continue;
            return true;
        }
        return false;
    }
}

