/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sql2java.maven;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import net.sourceforge.sql2java.CodeWriter;
import net.sourceforge.sql2java.Database;
import net.sourceforge.sql2java.maven.AbstractDbMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="sql2java", requiresDirectInvocation=true)
public class Sql2JavaMojo
extends AbstractDbMojo {
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}/generated-sources/sql2java", required=true)
    private File outputDirectory;
    @Parameter(property="propertiesFile", defaultValue="${project.basedir}/src/main/resources/sql2java.properties", required=true)
    private File propertiesFile;
    @Parameter(property="schemaAlias", defaultValue="test")
    private String schemaAlias;
    @Parameter(property="packageName", required=true)
    private String packageName;
    @Parameter(property="classPrefix", required=false)
    private String classPrefix;

    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    protected File getPropertiesFile() {
        return this.propertiesFile;
    }

    public void execute() throws MojoExecutionException {
        File f = this.outputDirectory;
        if (!f.exists()) {
            f.mkdirs();
        }
        if (!this.propertiesFile.exists()) {
            throw new MojoExecutionException(this.propertiesFile.getName() + " doesn't exist!");
        }
        Properties prop = new Properties();
        CodeWriter writer = null;
        try {
            prop.load(new FileInputStream(this.propertiesFile));
            Database db = new Database();
            db.setDriver(this.driver);
            db.setUrl(this.url);
            db.setUsername(this.user);
            db.setPassword(this.password);
            db.setCatalog(this.catalog);
            db.setSchema(this.schema);
            db.setTableNamePattern(Sql2JavaMojo.getProperty(prop, "jdbc.tablenamepattern"));
            if ("false".equalsIgnoreCase(Sql2JavaMojo.getProperty(prop, "jdbc.oracle.retrieve.remarks"))) {
                db.setOracleRetrieveRemarks(false);
            } else {
                db.setOracleRetrieveRemarks(true);
            }
            String tt = Sql2JavaMojo.getProperty(prop, "jdbc.tabletypes", "TABLE");
            StringTokenizer st = new StringTokenizer(tt, ",; \t");
            ArrayList<String> al = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                al.add(st.nextToken().trim());
            }
            db.setTableTypes(al.toArray(new String[al.size()]));
            db.load();
            if (this.packageName != null) {
                prop.setProperty("mgrwriter.package", this.packageName);
            }
            if (this.classPrefix != null) {
                prop.setProperty("mgrwriter.classprefix", this.classPrefix);
            }
            writer = new CodeWriter(db, prop);
            writer.setUseLibrary("net.sourceforge.sql2java.lib");
            writer.setDestinationFolder(this.outputDirectory.getPath());
            writer.process();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error executing plugin", e);
        }
        finally {
            if (writer != null) {
                writer.cleanup();
            }
        }
    }

    public static String getProperty(Properties prop, String key) {
        String s = prop.getProperty(key);
        return s != null ? s.trim() : s;
    }

    public static String getProperty(Properties prop, String key, String default_val) {
        String s = Sql2JavaMojo.getProperty(prop, key);
        if (s == null) {
            return default_val;
        }
        return s;
    }

    public static boolean isInArray(String[] ar, String code) {
        if (ar == null) {
            return false;
        }
        for (int i = 0; i < ar.length; ++i) {
            if (!code.equalsIgnoreCase(ar[i])) continue;
            return true;
        }
        return false;
    }
}

