/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sql2java.maven;

import java.io.File;
import java.io.FilenameFilter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import net.sourceforge.sql2java.maven.AbstractDbMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.hsqldb.cmdline.SqlFile;

@Mojo(name="sqlfile", requiresDirectInvocation=true)
public class SqlFileMojo
extends AbstractDbMojo {
    @Parameter(property="deleteData", defaultValue="false")
    private boolean deleteData;
    @Parameter(property="scriptDirectory", defaultValue="${project.basedir}/src/main/sql", required=true)
    private File scriptDirectory;

    protected File getScriptDirectory() {
        return this.scriptDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        Connection connection = null;
        try {
            Class.forName(this.driver);
            connection = DriverManager.getConnection(this.url, this.user, this.password);
            Object[] files = this.scriptDirectory.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(".sql");
                }
            });
            Arrays.sort(files);
            for (Object file : files) {
                this.getLog().info((CharSequence)String.format("Processing %s", file));
                SqlFile sqlFile = new SqlFile((File)file, null, false);
                sqlFile.setConnection(connection);
                sqlFile.execute();
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"", (Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    if (this.url.contains("jdbc:hsqldb:file")) {
                        Statement statement = connection.createStatement();
                        statement.executeUpdate("SHUTDOWN");
                        statement.close();
                    }
                }
                catch (SQLException ignore) {}
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }
}

