/*
 * Decompiled with CFR 0.152.
 */
package com.github.yeecode.dynamicdatasource;

import com.github.yeecode.dynamicdatasource.datasource.DynamicDataSourceConfig;
import com.github.yeecode.dynamicdatasource.model.DataSourceInfo;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class DynamicDataSource
extends AbstractRoutingDataSource {
    private static final ThreadLocal<String> CURRENT_DATASOURCE_NAME = new ThreadLocal();
    private ConcurrentHashMap<Object, Object> dataSourcesMap = new ConcurrentHashMap();
    private DataSource defaultDataSource;

    public DynamicDataSource(DataSource defaultDataSource) {
        super.setDefaultTargetDataSource((Object)defaultDataSource);
        super.setTargetDataSources(this.dataSourcesMap);
        this.defaultDataSource = defaultDataSource;
    }

    public Object determineCurrentLookupKey() {
        return CURRENT_DATASOURCE_NAME.get();
    }

    public synchronized boolean addDataSource(DataSourceInfo dataSourceInfo, Boolean overwrite) {
        if (this.dataSourcesMap.containsKey(dataSourceInfo.getName()) && !overwrite.booleanValue()) {
            return false;
        }
        DataSource dataSource = DynamicDataSourceConfig.createDataSource(dataSourceInfo);
        this.dataSourcesMap.put(dataSourceInfo.getName(), dataSource);
        super.afterPropertiesSet();
        return true;
    }

    public synchronized boolean addAndSwitchDataSource(DataSourceInfo dataSourceInfo, Boolean overwrite) {
        if (this.dataSourcesMap.containsKey(dataSourceInfo.getName()) && !overwrite.booleanValue()) {
            CURRENT_DATASOURCE_NAME.set(dataSourceInfo.getName());
            return false;
        }
        DataSource dataSource = DynamicDataSourceConfig.createDataSource(dataSourceInfo);
        this.dataSourcesMap.put(dataSourceInfo.getName(), dataSource);
        super.afterPropertiesSet();
        CURRENT_DATASOURCE_NAME.set(dataSourceInfo.getName());
        return true;
    }

    public synchronized boolean switchDataSource(String dataSourceName) {
        if (!this.dataSourcesMap.containsKey(dataSourceName)) {
            return false;
        }
        CURRENT_DATASOURCE_NAME.set(dataSourceName);
        return true;
    }

    public synchronized boolean delDataSource(String dataSourceName) {
        if (CURRENT_DATASOURCE_NAME.get().equals(dataSourceName)) {
            return false;
        }
        this.dataSourcesMap.remove(dataSourceName);
        return true;
    }

    public DataSource getDefaultDataSource() {
        return this.defaultDataSource;
    }
}

