/*
 * Decompiled with CFR 0.152.
 */
package Core.IO;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PropertiesHelper {
    private String src = "";
    private String encode = "utf-8";
    public Properties properties;
    private static Logger log = Logger.getLogger(PropertiesHelper.class);

    public void setSrc(String src) {
        this.src = src;
    }

    public PropertiesHelper(String src) {
        this.src = src;
    }

    public PropertiesHelper(String src, String encode) {
        this(src);
        this.encode = encode;
    }

    private Properties load() {
        if (this.src.trim().equals("")) {
            throw new RuntimeException("The path of Properties File is need");
        }
        InputStreamReader inputStream = null;
        this.properties = new Properties();
        try {
            inputStream = new InputStreamReader(ClassLoader.getSystemResourceAsStream(this.src), this.encode);
            this.properties.load(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.properties;
    }

    public String getValueByKey(String key) {
        String val = null;
        this.properties = this.load();
        if (this.properties != null) {
            val = this.properties.getProperty(key.trim());
        } else {
            log.error((Object)"Load event can't return object.");
        }
        return val;
    }

    public String getValueByKey(String key, String defaultValue) {
        this.properties = this.load();
        String val = this.properties.getProperty(key.trim(), defaultValue.trim());
        return val;
    }

    public Map<String, String> getAllProperties() {
        this.properties = this.load();
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration<?> enumeration = this.properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = this.getValueByKey(key);
            map.put(key, value);
        }
        return map;
    }

    public void addProperties(String key, String value) {
        this.properties = this.load();
        this.properties.put(key, value);
        try {
            this.write2File();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addAllProperties(Map<String, String> map) {
        this.properties = this.load();
        this.properties.putAll(map);
        try {
            this.write2File();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("write fail");
        }
    }

    public void update(String key, String value) {
        this.properties = this.load();
        if (!this.properties.containsKey(key)) {
            throw new RuntimeException("not such key");
        }
        this.properties.setProperty(key, value);
        try {
            this.write2File();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("write fail");
        }
    }

    public void deleteKey(String key) {
        this.properties = this.load();
        if (!this.properties.containsKey(key)) {
            throw new RuntimeException("not such key");
        }
        this.properties.remove(key);
        try {
            this.write2File();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("write fail");
        }
    }

    private void write2File() throws Exception {
        OutputStreamWriter outputStream = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(ClassLoader.getSystemResource(this.src).toURI())), this.encode);
        this.properties.store(outputStream, null);
        if (outputStream != null) {
            outputStream.close();
        }
    }
}

