/*
 * Decompiled with CFR 0.152.
 */
package Core.IO;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class ResourceHelper {
    private static Logger log = Logger.getLogger(ResourceHelper.class);

    public static Class loadClass(String className) {
        try {
            return ResourceHelper.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("class not found '" + className + "'", e);
        }
    }

    public static ClassLoader getClassLoader() {
        return ResourceHelper.class.getClassLoader();
    }

    public static InputStream getStream(String relativePath) throws IOException {
        if (!relativePath.contains("../")) {
            return ResourceHelper.getClassLoader().getResourceAsStream(relativePath);
        }
        return ResourceHelper.getStreamByExtendResource(relativePath);
    }

    public static String getResourceContent(String resource) throws IOException {
        String currentJarPackageDir = ResourceHelper.getCurrentJarPackageDir();
        String Path2 = currentJarPackageDir + resource;
        return FileUtils.readFileToString((File)new File(Path2), (String)"UTF-8");
    }

    private static String getCurrentJarPackageDir() throws IOException {
        String filePath = "";
        URL url = ResourceHelper.class.getProtectionDomain().getCodeSource().getLocation();
        try {
            filePath = URLDecoder.decode(url.getPath(), "utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (filePath.endsWith(".jar")) {
            filePath = filePath.substring(0, filePath.lastIndexOf("/") + 1);
        }
        File file = new File(filePath);
        filePath = file.getCanonicalPath();
        return filePath + File.separator;
    }

    public static InputStream getStream(URL url) throws IOException {
        if (url != null) {
            return url.openStream();
        }
        return null;
    }

    public static InputStream getStreamByExtendResource(String relativePath) throws MalformedURLException, IOException {
        return ResourceHelper.getStream(ResourceHelper.getExtendResource(relativePath));
    }

    public static Properties getProperties(String resource) {
        Properties properties = new Properties();
        try {
            properties.load(ResourceHelper.getStream(resource));
        }
        catch (IOException e) {
            throw new RuntimeException("couldn't load properties file '" + resource + "'", e);
        }
        return properties;
    }

    public static String getAbsolutePathOfClassLoaderClassPath() {
        try {
            URL url = ResourceHelper.getClassLoader().getResource("");
            return url.getPath();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static URL getExtendResource(String relativePath) throws MalformedURLException {
        log.info((Object)("\u4f20\u5165\u7684\u76f8\u5bf9\u8def\u5f84\uff1a" + relativePath));
        if (!relativePath.contains("../")) {
            return ResourceHelper.getResource(relativePath);
        }
        String classPathAbsolutePath = ResourceHelper.getAbsolutePathOfClassLoaderClassPath();
        if (relativePath.substring(0, 1).equals("/")) {
            relativePath = relativePath.substring(1);
        }
        log.info((Object)relativePath.lastIndexOf("../"));
        String wildcardString = relativePath.substring(0, relativePath.lastIndexOf("../") + 3);
        relativePath = relativePath.substring(relativePath.lastIndexOf("../") + 3);
        int containSum = ResourceHelper.containSum(wildcardString, "../");
        classPathAbsolutePath = ResourceHelper.cutLastString(classPathAbsolutePath, "/", containSum);
        String resourceAbsolutePath = classPathAbsolutePath + relativePath;
        log.info((Object)("\u7edd\u5bf9\u8def\u5f84\uff1a" + resourceAbsolutePath));
        URL resourceAbsoluteURL = new URL(resourceAbsolutePath);
        return resourceAbsoluteURL;
    }

    private static int containSum(String source, String dest) {
        int containSum = 0;
        int destLength = dest.length();
        while (source.contains(dest)) {
            ++containSum;
            source = source.substring(destLength);
        }
        return containSum;
    }

    private static String cutLastString(String source, String dest, int num) {
        for (int i = 0; i < num; ++i) {
            source = source.substring(0, source.lastIndexOf(dest, source.length() - 2) + 1);
        }
        return source;
    }

    public static URL getResource(String resource) {
        log.info((Object)("Get Resource path is: " + resource));
        return ResourceHelper.getClassLoader().getResource(resource);
    }

    public static void main(String[] args) throws MalformedURLException {
    }
}

