/*
 * Decompiled with CFR 0.152.
 */
package Core.IO;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipHelper {
    public void Zip(String zipFileName, String sourceFileName) throws IOException {
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFileName)));
        BufferedOutputStream bos = new BufferedOutputStream(out);
        File sourceFile = new File(sourceFileName);
        this.compress(out, bos, sourceFile, sourceFile.getName());
        bos.close();
        out.close();
    }

    private void compress(ZipOutputStream out, BufferedOutputStream bos, File sourceFile, String base) throws IOException {
        if (sourceFile.isDirectory()) {
            File[] flist = sourceFile.listFiles();
            if (flist.length == 0) {
                System.out.println(base + "/");
                out.putNextEntry(new ZipEntry(base + "/"));
            } else {
                for (int i = 0; i < flist.length; ++i) {
                    this.compress(out, bos, flist[i], base + "/" + flist[i].getName());
                }
            }
        } else {
            int tag;
            out.putNextEntry(new ZipEntry(base));
            FileInputStream fos = new FileInputStream(sourceFile);
            BufferedInputStream bis = new BufferedInputStream(fos);
            System.out.println(base);
            while ((tag = bis.read()) != -1) {
                bos.write(tag);
            }
            bis.close();
            fos.close();
        }
    }

    public void unZipFiles(String zipPath, String descDir) throws IOException {
        this.unZipFiles(new File(zipPath), descDir);
    }

    public void unZipFiles(File zipFile, String descDir) throws IOException {
        ZipFile zip = new ZipFile(zipFile, Charset.forName("GBK"));
        File pathFile = new File(descDir);
        if (!pathFile.exists()) {
            pathFile.mkdirs();
        }
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            int len;
            ZipEntry entry = entries.nextElement();
            String zipEntryName = entry.getName();
            InputStream in = zip.getInputStream(entry);
            String outPath = (descDir + "/" + zipEntryName).replaceAll("\\*", "/");
            File file = new File(outPath.substring(0, outPath.lastIndexOf(47)));
            if (!file.exists()) {
                file.mkdirs();
            }
            if (new File(outPath).isDirectory()) continue;
            FileOutputStream out = new FileOutputStream(outPath);
            byte[] buf1 = new byte[1024];
            while ((len = in.read(buf1)) > 0) {
                out.write(buf1, 0, len);
            }
            in.close();
            out.close();
        }
    }

    public static void main(String[] args) {
        try {
            ZipHelper zip = new ZipHelper();
            zip.unZipFiles(new File("C:\\Users\\jzhang13\\Desktop\\ForTest\\20170629.zip"), "C:\\Users\\jzhang13\\Desktop\\ForTest\\");
            System.out.println("\u89e3\u538b\u7f29\u4e2d...");
            zip.Zip("C:\\Users\\jzhang13\\Desktop\\ForTest\\20170605.zip", "C:\\Users\\jzhang13\\Desktop\\ForTest\\20170605");
            System.out.println("\u538b\u7f29\u5b8c\u6210");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

