package cdc.issues.api;

import java.util.ArrayList;
import java.util.List;

/**
 * A collector of issues that can delegate issues.
 *
 * @author Damien Carbonne
 *
 * @param <T> The issue type.
 */
public class IssuesCollector<T> implements IssuesHandler<T> {
    private final List<Issue<? extends T>> issues = new ArrayList<>();
    private final IssuesHandler<T> delegate;

    public IssuesCollector(IssuesHandler<T> delegate) {
        this.delegate = delegate;
    }

    public IssuesCollector() {
        this.delegate = null;
    }

    /**
     * @return The delegate (possibly {@code null}).
     */
    public IssuesHandler<T> getDelegate() {
        return delegate;
    }

    /**
     * Clears collected issues.
     */
    public void clear() {
        issues.clear();
    }

    /**
     * @return The list of collected issues.
     */
    public List<Issue<? extends T>> getIssues() {
        return issues;
    }

    @Override
    public void issue(Issue<? extends T> issue) {
        issues.add(issue);
        if (delegate != null) {
            delegate.issue(issue);
        }
    }
}