package cdc.issues.api;

import java.io.File;
import java.io.IOException;
import java.util.List;

import cdc.util.office.ss.WorkbookWriter;
import cdc.util.office.ss.WorkbookWriterFactory;
import cdc.util.tables.TableSection;

/**
 * Class use to save issues to a workbook.
 *
 * @author Damien Carbonne
 */
public class IssuesWorkbookWriter {
    private final WorkbookWriterFactory factory = new WorkbookWriterFactory();

    public IssuesWorkbookWriter() {
        factory.setEnabled(WorkbookWriterFactory.Feature.AUTO_SIZE_COLUMNS, true);
        factory.setEnabled(WorkbookWriterFactory.Feature.AUTO_FILTER_COLUMNS, true);
    }

    public WorkbookWriterFactory getWorkbookWriterFactory() {
        return factory;
    }

    public void save(List<? extends Issue<?>> issues,
                     File file) throws IOException {
        try (WorkbookWriter<?> writer = factory.create(file)) {
            writer.beginSheet("Issues");
            writer.beginRow(TableSection.HEADER);
            writer.addCells("Type", "Level", "Description", "# Locations", "Target Ids", "Paths");
            for (final Issue<?> issue : issues) {
                writer.beginRow(TableSection.DATA);
                writer.addCell(issue.getType());
                writer.addCell(issue.getLevel());
                writer.addCell(issue.getDescription());
                writer.addCell(issue.getLocations().length);

                final StringBuilder ids = new StringBuilder();
                final StringBuilder paths = new StringBuilder();
                boolean first = true;
                for (final IssueLocation location : issue.getLocations()) {
                    if (first) {
                        first = false;
                    } else {
                        ids.append("\n");
                        paths.append("\n");
                    }
                    ids.append(location.getTargetId());
                    paths.append(location.getPath());
                }
                writer.addCell(ids.toString());
                writer.addCell(paths.toString());
            }
            writer.flush();
        }
    }
}