package cdc.issues.api.locations;

import cdc.issues.api.IssueLocation;
import cdc.util.lang.Checks;

/**
 * Implementation of IssueLocation dedicated to text files.
 *
 * @author Damien Carbonne
 */
public class TextFileIssueLocation implements IssueLocation {
    private final String systemId;
    private final int lineNumber;
    private final int columnNumber;

    private TextFileIssueLocation(String systemId,
                                  int lineNumber,
                                  int columnNumber) {
        this.systemId = Checks.isNotNull(systemId, "systemId");
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    @Override
    public String getTargetId() {
        return getSystemId();
    }

    @Override
    public String getPath() {
        return getLineNumber() + ":" + getColumnNumber();
    }

    public String getSystemId() {
        return systemId;
    }

    public int getLineNumber() {
        return lineNumber;
    }

    public int getColumnNumber() {
        return columnNumber;
    }

    @Override
    public String toString() {
        return getSystemId()
                + ":" + getLineNumber()
                + ":" + getColumnNumber();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String systemId;
        private int lineNumber;
        private int columnNumber;

        private Builder() {
            super();
        }

        public Builder systemId(String systemId) {
            this.systemId = systemId;
            return this;
        }

        public Builder lineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
            return this;
        }

        public Builder columnNumber(int columnNumber) {
            this.columnNumber = columnNumber;
            return this;
        }

        public TextFileIssueLocation build() {
            return new TextFileIssueLocation(systemId,
                                             lineNumber,
                                             columnNumber);
        }
    }
}