package cdc.issues;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public final class IssueUtils {
    private IssueUtils() {
    }

    public static Set<String> getMetaNames(Collection<? extends Issue> issues) {
        final Set<String> set = new HashSet<>();
        for (final Issue issue : issues) {
            set.addAll(issue.getMetas().getNames());
        }
        return set;
    }

    public static Set<String> getParamNames(Collection<? extends Issue> issues) {
        final Set<String> set = new HashSet<>();
        for (final Issue issue : issues) {
            set.addAll(issue.getParams().getNames());
        }
        return set;
    }
}