package cdc.issues;

import java.time.Instant;
import java.util.List;
import java.util.Optional;

public interface Snapshot {

    /**
     * @return The project to which this snapshot belongs.
     */
    public Optional<Project> getProject();

    /**
     * @return The timestamp of this snapshot.
     */
    public Instant getTimestamp();

    /**
     * @return The name of this snapshot.
     */
    public String getName();

    /**
     * @return The issues of this snapshot.
     */
    public List<Issue> getIssues();
}