package cdc.issues.io;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;

import cdc.issues.Issue;
import cdc.issues.answers.IssueAnswer;

public interface IssuesStreamWriter extends Flushable, Closeable {
    public void startDocument() throws IOException;

    public void add(SnapshotData snapshot) throws IOException;

    public void add(Issue issue,
                    IssueAnswer answer) throws IOException;

    public default void add(Issue issue) throws IOException {
        add(issue, null);
    }

    public void endDocument() throws IOException;
}