package cdc.issues.rules;

import java.util.Objects;

import cdc.util.lang.Checks;

/**
 * Rule identifier.
 * <p>
 * It is composed of a domain and a name (in the domain).
 *
 * @author Damien Carbonne
 */
public class RuleId implements Comparable<RuleId> {
    private final String domain;
    private final String name;

    public RuleId(String domain,
                  String name) {
        this.domain = Checks.isNotNull(domain, "domain");
        this.name = Checks.isNotNull(name, "name");
    }

    public RuleId(String domain,
                  Enum<?> name) {
        this(domain,
             name.name());
    }

    public String getDomain() {
        return domain;
    }

    public String getName() {
        return name;
    }

    public <T extends Enum<T>> T getName(Class<T> cls) {
        return Enum.valueOf(cls, name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(domain,
                            name);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RuleId)) {
            return false;
        }
        final RuleId other = (RuleId) object;
        return this.domain.equals(other.domain)
                && this.name.equals(other.name);
    }

    @Override
    public int compareTo(RuleId other) {
        final int domainCmp = domain.compareTo(other.domain);
        if (domainCmp == 0) {
            return name.compareTo(other.name);
        } else {
            return domainCmp;
        }
    }

    @Override
    public String toString() {
        return domain + "/" + name;
    }

}