package cdc.issues.rules;

import java.util.Set;

import cdc.issues.Params;

/**
 * Interface describing a Profile.
 * <p>
 * It is a set of {@link ConfiguredRule ConfiguredRules}, some of which are enabled.
 *
 * @author Damien Carbonne
 */
public interface Profile {
    /**
     * @return The profile name.
     */
    public String getName();

    /**
     * @return The meta data associated to this profile.
     */
    public Params getMetas();

    /**
     * @return The set of rules in this profile.
     */
    public Set<Rule> getRules();

    /**
     * @return The set of configured rules in this profile.
     */
    public Set<ConfiguredRule> getConfiguredRules();

    /**
     * @return The set of rules that are enabled in this profile.
     */
    public Set<Rule> getEnabledRules();

    /**
     * @return The set of configured rules that are enabled in this profile.
     */
    public Set<ConfiguredRule> getEnabledConfiguredRules();

    /**
     * @param rule The rule.
     * @return {@code true} if {@code rule} is enabled in this profile.
     * @throws IllegalArgumentException When {@code rule} is {@code null}.
     */
    public boolean isEnabled(Rule rule);

    /**
     * Returns the parameters to use for a rule.
     *
     * @param rule The rule.
     * @return The parameters that are used to configure {@code rule}
     *         in this profile.
     * @throws IllegalArgumentException When {@code rule} is {@code null}.
     */
    public Params getParams(Rule rule);
}