package cdc.issues;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertNotEquals;

import org.junit.jupiter.api.Test;

import cdc.issues.locations.DefaultLocatedData;
import cdc.issues.locations.DefaultLocation;
import cdc.issues.locations.Location;

class DefaultLocatedDataTest {
    @Test
    void test() {
        final Location location1 = new DefaultLocation("path1", "anchor");
        final Location location2 = new DefaultLocation("path2", "anchor");
        final DefaultLocatedData<String> data0a = new DefaultLocatedData<>(null, location1);
        final DefaultLocatedData<String> data0b = new DefaultLocatedData<>(null, location1);
        final DefaultLocatedData<String> data1a = new DefaultLocatedData<>("Hello", location1);
        final DefaultLocatedData<String> data1b = new DefaultLocatedData<>("Hello", location1);
        final DefaultLocatedData<String> data2a = new DefaultLocatedData<>("Hello", location2);
        final DefaultLocatedData<String> data2b = new DefaultLocatedData<>("Hello", location2);

        assertNotEquals(data0a, null);
        assertNotEquals(data0a, "Hello");
        assertEquals(data0a, data0a);
        assertEquals(data0a, data0b);
        assertEquals(data1a, data1b);
        assertEquals(data2a, data2b);
        assertNotEquals(data1a, data2b);
        assertNotEquals(data0a, data2b);

        assertEquals(null, data0a.getData());
        assertEquals(location1, data0a.getLocations().get(0));
        assertEquals("Hello", data1a.getData());

        assertEquals(data2a.hashCode(), data2b.hashCode());
        assertEquals(data2a.toString(), data2b.toString());

    }
}
