package cdc.issues;

/**
 * Interface implemented by classes that can return a {@link Diagnosis}.
 *
 * @author Damien Carbonne
 *
 * @param <I> The issue type.
 */
@FunctionalInterface
public interface HasDiagnosis<I extends Issue> {
    /**
     * @return The diagnosis.
     */
    public Diagnosis<I> getDiagnosis();
}