package cdc.issues.io;

import java.time.Instant;
import java.util.Optional;

import cdc.issues.Params;
import cdc.issues.Snapshot;
import cdc.issues.rules.Profile;

/**
 * Interface describing the synthetic data associated to a {@link Snapshot}.
 *
 * @author Damien Carbonne
 */
public interface SnapshotData {
    /**
     * @return The project name.
     */
    public String getProjectName();

    /**
     * @return The project meta data.
     */
    public Params getProjectMetas();

    /**
     * @return The project profile.
     */
    public Optional<? extends Profile> getProfile();

    /**
     * @return The snapshot name.
     */
    public String getSnapshotName();

    /**
     * @return The snapshot meta data.
     */
    public Params getSnapshotMetas();

    /**
     * @return The snapshot timestamp.
     */
    public Instant getSnapshotTimestamp();

    /**
     * @return The number of issues of the snapshot.
     */
    public int getNumberOfIssues();
}