package cdc.issues;

import static org.junit.jupiter.api.Assertions.assertEquals;

import org.junit.jupiter.api.Test;

import cdc.issues.api.Issue;
import cdc.issues.api.IssueLevel;
import cdc.issues.api.locations.TextFileIssueLocation;

class IssueTest {
    @Test
    void test1() {
        final Issue<String> issue = Issue.builder(String.class)
                                         .type("Type")
                                         .addLocation(TextFileIssueLocation.builder()
                                                                           .systemId("file")
                                                                           .build())
                                         .level(IssueLevel.FATAL)
                                         .description("description")
                                         .build();

        assertEquals("Type", issue.getIssueType());
    }
}