package cdc.issues.api.locations;

import cdc.util.lang.Checks;

/**
 * Default implementation of IssueLocation.
 * <p>
 * For example, it can be used to designate the attribute of an object.
 *
 * @author Damien Carbonne
 */
public class DefaultIssueLocation extends AbstractIssueLocation {
    private final String targetId;
    private final String path;

    public DefaultIssueLocation(String targetId,
                                String path) {
        this.targetId = Checks.isNotNull(targetId, "targetId");
        this.path = path;
    }

    public DefaultIssueLocation(String targetId) {
        this(targetId, null);
    }

    @Override
    public String getTargetId() {
        return targetId;
    }

    @Override
    public String getPath() {
        return path;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String targetId;
        private String path = null;

        private Builder() {
            super();
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public DefaultIssueLocation build() {
            return new DefaultIssueLocation(targetId,
                                            path);
        }
    }
}