package cdc.issues.api;

import static org.junit.jupiter.api.Assertions.assertEquals;

import org.junit.jupiter.api.Test;

import cdc.issues.api.locations.TextFileIssueLocation;

class IssueTest {
    @Test
    void test1() {
        final Issue issue = Issue.builder()
                                 .domain("Domain")
                                 .name("Type")
                                 .addLocation(TextFileIssueLocation.builder()
                                                                   .systemId("file")
                                                                   .build())
                                 .severity(IssueSeverity.BLOCKER)
                                 .description("description")
                                 .build();

        assertEquals("Type", issue.getName());
    }
}