package cdc.issues.api;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertNotEquals;

import org.junit.jupiter.api.Test;

class RuleTest {

    @Test
    void test() {
        final Rule rule1 = Rule.builder()
                               .domain("Domain")
                               .name("Name")
                               .severity(IssueSeverity.BLOCKER)
                               .description("Description")
                               .build();

        final Rule rule2 = Rule.builder()
                               .domain("Domain")
                               .name("Name")
                               .severity(IssueSeverity.BLOCKER)
                               .description("Description")
                               .build();
        final Rule rule3 = Rule.builder()
                               .domain("Domain")
                               .name(IssuesFormat.CSV)
                               .severity(IssueSeverity.BLOCKER)
                               .description("Description")
                               .params(RuleParams.builder()
                                                 .param("P1", "Description")
                                                 .build())
                               .build();

        assertEquals(rule1, rule1);
        assertEquals(rule1, rule2);
        assertNotEquals(rule1, rule3);
        assertNotEquals(rule1, null);
        assertNotEquals(rule1, "Hello");
        assertEquals(rule1.hashCode(), rule2.hashCode());
        assertEquals(rule1.getId(), rule2.getId());

        assertEquals("Description", rule1.getDescription());
        assertEquals("Domain", rule1.getDomain());
        assertEquals("Name", rule1.getName());
        assertEquals(RuleParams.NO_PARAMS, rule1.getParams());
        assertEquals(IssueSeverity.BLOCKER, rule1.getSeverity());
        assertEquals(IssuesFormat.CSV, rule3.getName(IssuesFormat.class));

    }
}