package cdc.issues.rules;

import java.util.Objects;

import cdc.issues.Params;
import cdc.util.lang.Checks;

/**
 * Association of a Rule to Parameters.
 *
 * @author Damien Carbonne
 */
public class ConfiguredRule {
    private final Rule rule;
    private final Params params;

    public ConfiguredRule(Rule rule,
                          Params params) {
        this.rule = Checks.isNotNull(rule, "rule");
        this.params = Checks.isNotNull(params, "params");
    }

    public ConfiguredRule(Rule rule) {
        this(rule,
             Params.NO_PARAMS);
    }

    public final Rule getRule() {
        return rule;
    }

    public final Params getParams() {
        return params;
    }

    @Override
    public int hashCode() {
        return Objects.hash(rule,
                            params);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ConfiguredRule)) {
            return false;
        }
        final ConfiguredRule other = (ConfiguredRule) object;
        return Objects.equals(rule, other.rule)
                && Objects.equals(params, other.params);
    }

    @Override
    public String toString() {
        return "[" + getRule().getName() + ", " + getParams() + "]";
    }
}