package cdc.issues.rules;

import java.util.function.Consumer;

import cdc.issues.IssueSeverity;

public final class RuleUtils {
    private RuleUtils() {
    }

    public static Rule define(String domain,
                              String name,
                              Consumer<RuleDescription.Builder<?>> descriptionBuilder,
                              IssueSeverity... severities) {
        final RuleDescription.Builder<?> description = RuleDescription.builder();
        descriptionBuilder.accept(description);
        final Rule.Builder builder = Rule.builder()
                                         .domain(domain)
                                         .name(name)
                                         .description(description.build().toString())
                                         .severities(severities);
        return builder.build();
    }
}