package cdc.issues.api.locations;

import java.util.Objects;

public abstract class AbstractLocation implements Location {
    @Override
    public int hashCode() {
        return Objects.hash(getTargetId(),
                            getPath());
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AbstractLocation)) {
            return false;
        }
        final AbstractLocation other = (AbstractLocation) object;
        return Objects.equals(this.getTargetId(), other.getTargetId())
                && Objects.equals(this.getPath(), other.getPath());
    }

    @Override
    public String toString() {
        return Location.toString(this);
    }
}