package cdc.issues.api.locations;

import cdc.util.strings.StringUtils;

/**
 * Base interface used to describe an Issue location.
 * <p>
 * It is composed of 2 parts:
 * <ul>
 * <li>A target
 * <li>A path relatively to this target.
 * </ul>
 * The path can be empty.
 *
 * @author Damien Carbonne
 */
public interface Location {
    public static final Location UNDEFINED = new DefaultLocation("", null);

    /**
     * @return The identifier of the issue target.<br>
     *         It is typically a file or a business object that has a user meaningful 'absolute' identifier.<br>
     *         It can contain a path to the identified target.
     */
    public String getTargetId();

    /**
     * @return The path, relative to target, of the issue.
     *         It may be {@code null}.
     */
    public String getPath();

    public default boolean hasPath() {
        return !StringUtils.isNullOrEmpty(getPath());
    }

    public static String toString(Location location) {
        final String path = location.getPath();
        return StringUtils.isNullOrEmpty(path)
                ? location.getTargetId()
                : location.getTargetId() + ":" + path;
    }
}