package cdc.issues;

/**
 * Interface implemented by builders that have labels.
 *
 * @param <B> The builder class.
 */
public interface LabelsBuilding<B> {
    /**
     * The the labels.
     *
     * @param labels The labels.
     * @return This builder.
     */
    public B labels(Labels labels);

    /**
     * The the labels.
     *
     * @param labels The labels.
     * @return This builder.
     */
    public default B labels(String... labels) {
        return labels(Labels.of(labels));
    }
}