package cdc.issues.answers;

import java.time.Instant;

/**
 * Interface describing an issue comment.
 *
 * @author Damien Carbonne
 */
public interface IssueComment {

    /**
     * @return The author of this comment.
     */
    public String getAuthor();

    /**
     * @return The date (as an Instant) of this comment.
     */
    public Instant getDate();

    /**
     *
     * @return The text of this comment.
     */
    public String getText();

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        String author;
        Instant date;
        String text;

        protected Builder() {
        }

        public Builder author(String author) {
            this.author = author;
            return this;
        }

        public Builder date(Instant date) {
            this.date = date;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public IssueComment build() {
            return new IssueCommentImpl(this.author,
                                        this.date == null ? Instant.now() : this.date,
                                        this.text);
        }
    }
}

record IssueCommentImpl(String author,
                        Instant date,
                        String text)
        implements IssueComment {
    @Override
    public String getAuthor() {
        return author;
    }

    @Override
    public Instant getDate() {
        return date;
    }

    @Override
    public String getText() {
        return text;
    }
}