package cdc.issues.io;

import java.io.File;
import java.io.IOException;
import java.util.List;

import cdc.issues.Issue;
import cdc.issues.IssuesFactory;
import cdc.issues.IssuesFactoryFeatures;

public interface IssuesReader {
    public List<Issue> load(File file) throws IOException;

    public static List<Issue> load(File file,
                                   IssuesFactoryFeatures features) throws IOException {
        final IssuesFactory factory = new IssuesFactory(features);
        final IssuesReader reader = factory.createIssuesReader(file);
        return reader.load(file);
    }
}