package cdc.issues.rules;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import cdc.issues.Params;
import cdc.util.lang.Checks;

public abstract class AbstractIssueDetector<T> implements IssuesDetector<T> {
    protected final Descriptor<T> descriptor;
    protected final Params params;
    protected final Set<Rule> enabledRules;

    protected AbstractIssueDetector(Descriptor<T> descriptor,
                                    Params params,
                                    Set<Rule> rules) {
        this.descriptor = Checks.isNotNull(descriptor, "descriptor");
        this.params = Checks.isNotNull(params, "params");
        this.enabledRules = Collections.unmodifiableSet(new HashSet<>(rules));
        if (!descriptor.getRules().containsAll(enabledRules)) {
            throw new IllegalArgumentException("Non supported rules");
        }
    }

    protected AbstractIssueDetector(Descriptor<T> descriptor,
                                    Set<Rule> rules) {
        this(descriptor,
             Params.NO_PARAMS,
             rules);
    }

    @Override
    public Descriptor<T> getDescriptor() {
        return descriptor;
    }

    @Override
    public final Set<Rule> getEnabledRules() {
        return enabledRules;
    }

    @Override
    public final Params getParams() {
        return params;
    }

    @Override
    public String toString() {
        return IssuesDetector.toString(this);
    }
}