/*
 * Decompiled with CFR 0.152.
 */
package cdc.app;

import cdc.app.AppInfo;
import cdc.io.json.JsonpUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;

public final class AppInfoIo {
    private static final String TIMESTAMP = "timestamp";
    private static final String MAIN_ARGS = "mainArguments";
    private static final String VM_ARGS = "vmArguments";
    private static final String APP_PROPS = "appProperties";
    private static final String ENV_VARS = "envVariables";
    private static final String SYS_PROPS = "sysProperties";
    private static final String STACK_TRACE = "stackTrace";
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_DATE_TIME;
    private static final DateTimeFormatter DATE_TIME = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss.SSSSSS");

    private AppInfoIo() {
    }

    private static LocalDateTime toLocalDateTime(Instant instant) {
        return LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
    }

    private static String toString(Instant instant) {
        return FORMATTER.format(AppInfoIo.toLocalDateTime(instant));
    }

    private static void write(JsonGenerator generator, String name, String value) {
        if (value == null) {
            generator.writeNull(name);
        } else {
            generator.write(name, value);
        }
    }

    public static File generateJsonExceptionFile(File dir, Instant instant) {
        String s = DATE_TIME.format(LocalDateTime.ofInstant(instant, ZoneId.systemDefault()));
        return new File(dir, s + "-exception.json");
    }

    public static File generateJsonExceptionFile(File dir) {
        return AppInfoIo.generateJsonExceptionFile(dir, Instant.now());
    }

    public static void saveAsJson(AppInfo info, File file) throws IOException {
        JsonGeneratorFactory factory = Json.createGeneratorFactory((Map)JsonpUtils.PRETTY_CONFIG);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));
             JsonGenerator generator = factory.createGenerator((Writer)writer);){
            generator.writeStartObject();
            generator.write(TIMESTAMP, AppInfoIo.toString(info.getTimestamp()));
            generator.writeStartArray(MAIN_ARGS);
            info.getMainArgs().stream().forEach(arg_0 -> ((JsonGenerator)generator).write(arg_0));
            generator.writeEnd();
            generator.writeStartArray(VM_ARGS);
            info.getVMArgs().stream().forEach(arg_0 -> ((JsonGenerator)generator).write(arg_0));
            generator.writeEnd();
            generator.writeStartObject(APP_PROPS);
            info.getAppPropsNames().stream().sorted().forEach(name -> AppInfoIo.write(generator, name, info.getAppPropValue((String)name)));
            generator.writeEnd();
            generator.writeStartObject(ENV_VARS);
            info.getEnvVarsNames().stream().sorted().forEach(name -> AppInfoIo.write(generator, name, info.getEnvVarValue((String)name)));
            generator.writeEnd();
            generator.writeStartObject(SYS_PROPS);
            info.getSysPropsNames().stream().sorted().forEach(name -> AppInfoIo.write(generator, name, info.getSysPropValue((String)name)));
            generator.writeEnd();
            if (info.hasStackTrace()) {
                generator.writeStartArray(STACK_TRACE);
                info.getStackTrace().stream().forEach(arg_0 -> ((JsonGenerator)generator).write(arg_0));
                generator.writeEnd();
            }
            generator.writeEnd();
            generator.flush();
        }
    }
}

