package cdc.util.cli;

import java.io.IOException;
import java.util.Arrays;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

/**
 * Program that shows regression (commons-cli-1.10.0) in formatting of groups.
 */
public class CliOptionGroups {
    private static void parse(Options options,
                              String... args) {
        System.err.println("parse(" + Arrays.toString(args) + ")");
        final CommandLineParser parser = new DefaultParser();
        try {
            final CommandLine cl = parser.parse(options, args);
            System.err.println("options: " + Arrays.toString(cl.getOptions()));
        } catch (final ParseException e) {
            e.printStackTrace();
        }

    }

    public static void main(String[] args) throws IOException {
        final Option o1 = new Option("o1", "Descr");
        final Option o2 = new Option("o2", "Descr");

        final Options options = new Options();
        options.addOption(o1);
        options.addOption(o2);

        final OptionGroup group = new OptionGroup();
        group.setRequired(true);
        group.addOption(o1);
        group.addOption(o2);
        options.addOptionGroup(group);

        final org.apache.commons.cli.help.HelpFormatter newFormatter =
                org.apache.commons.cli.help.HelpFormatter.builder()
                                                         .setShowSince(false)
                                                         .get();
        newFormatter.printHelp("Command", null, options, null, true);

        final org.apache.commons.cli.HelpFormatter oldFormatter =
                new org.apache.commons.cli.HelpFormatter();
        oldFormatter.printHelp("Command", null, options, null, true);

        parse(options);
        parse(options, "-o1");
        parse(options, "-o2");
        parse(options, "-o1", "-o2");

    }
}