package cdc.util.cli;

import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertSame;
import static org.junit.jupiter.api.Assertions.assertTrue;

import org.junit.jupiter.api.Test;

class OptionEnumTypeTest {

    static class A {
        public static final OptionEnumType TYPE = new OptionEnumType();
        public static final OptionEnum OPTION1 = TYPE.value("o1").build();
        public static final OptionEnum OPTION2 = TYPE.value("o2").build();
        public final OptionEnumMask features = new OptionEnumMask(TYPE);

        public static void elaborate() {
            // Ignore
        }
    }

    static class B extends A {
        public static final OptionEnum OPTION3 = TYPE.value("o3").build();

        public static void elaborate() {
            A.elaborate();
        }
    }

    @Test
    void test() {
        B.elaborate();
        assertSame(3, A.TYPE.getValues().size());

        final A a = new A();
        assertTrue(a.features.isEmpty());
        a.features.setEnabled(A.OPTION1, true);
        assertFalse(a.features.isEmpty());
    }
}