package cdc.util.cli;

import java.io.IOException;
import java.util.Collections;

import org.apache.commons.cli.help.HelpFormatter;

public class TestCommonsCliHelpFormatter {
    public static void main(String[] args) throws IOException {
        final HelpFormatter formatter = HelpFormatter.builder()
                                                     .get();

        System.out.println("==============================");
        // OK
        formatter.printHelp("CL syntax",
                            "Header",
                            Collections.emptyList(),
                            "Footer",
                            true);

        System.out.println("==============================");
        // OK
        formatter.printHelp("CL syntax",
                            "Header\n",
                            Collections.emptyList(),
                            "Footer\n",
                            true);

        System.out.println("==============================");
        // KO Header
        formatter.printHelp("CL syntax",
                            "Header\n\n",
                            Collections.emptyList(),
                            "Footer",
                            true);

        System.out.println("==============================");
        // KO Footer
        formatter.printHelp("CL syntax",
                            "Header",
                            Collections.emptyList(),
                            "Footer\n\n",
                            true);
    }
}