/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.helper;

import com.googlecode.androidannotations.helper.APTCodeModelHelper;
import com.googlecode.androidannotations.helper.IdAnnotationHelper;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.googlecode.androidannotations.processing.TextWatcherHolder;
import com.googlecode.androidannotations.rclass.IRClass;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCast;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.lang.annotation.Annotation;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.TypeMirror;

public class TextWatcherHelper
extends IdAnnotationHelper {
    private final APTCodeModelHelper codeModelHelper;

    public TextWatcherHelper(ProcessingEnvironment processingEnv, Class<? extends Annotation> target, IRClass rClass, APTCodeModelHelper codeModelHelper) {
        super(processingEnv, target, rClass);
        this.codeModelHelper = codeModelHelper;
    }

    public TextWatcherHolder getOrCreateListener(JCodeModel codeModel, EBeanHolder holder, JFieldRef idRef, TypeMirror viewParameterType) {
        String idRefString = this.codeModelHelper.getIdStringFromIdFieldRef(idRef);
        TextWatcherHolder textWatcherHolder = holder.textWatchers.get(idRefString);
        if (textWatcherHolder == null) {
            JClass viewClass;
            JClass charSequenceClass = holder.classes().CHAR_SEQUENCE;
            JDefinedClass onTextChangeListenerClass = codeModel.anonymousClass(holder.classes().TEXT_WATCHER);
            JMethod afterTextChangedMethod = onTextChangeListenerClass.method(1, codeModel.VOID, "afterTextChanged");
            afterTextChangedMethod.param(holder.classes().EDITABLE, "s");
            afterTextChangedMethod.annotate(Override.class);
            JMethod onTextChangedMethod = onTextChangeListenerClass.method(1, codeModel.VOID, "onTextChanged");
            onTextChangedMethod.param(charSequenceClass, "s");
            onTextChangedMethod.param(codeModel.INT, "start");
            onTextChangedMethod.param(codeModel.INT, "before");
            onTextChangedMethod.param(codeModel.INT, "count");
            onTextChangedMethod.annotate(Override.class);
            JMethod beforeTextChangedMethod = onTextChangeListenerClass.method(1, codeModel.VOID, "beforeTextChanged");
            beforeTextChangedMethod.param(charSequenceClass, "s");
            beforeTextChangedMethod.param(codeModel.INT, "start");
            beforeTextChangedMethod.param(codeModel.INT, "count");
            beforeTextChangedMethod.param(codeModel.INT, "after");
            beforeTextChangedMethod.annotate(Override.class);
            JBlock block = holder.afterSetContentView.body().block();
            if (viewParameterType != null) {
                String viewParameterTypeString = ((Object)viewParameterType).toString();
                viewClass = holder.refClass(viewParameterTypeString);
            } else {
                viewClass = holder.classes().TEXT_VIEW;
            }
            JCast findViewById = JExpr.cast(viewClass, JExpr.invoke("findViewById").arg(idRef));
            JVar viewVariable = block.decl(8, viewClass, "view", findViewById);
            block._if(viewVariable.ne(JExpr._null()))._then().invoke((JExpression)viewVariable, "addTextChangedListener").arg(JExpr._new(onTextChangeListenerClass));
            textWatcherHolder = new TextWatcherHolder(afterTextChangedMethod, beforeTextChangedMethod, onTextChangedMethod, viewVariable);
            holder.textWatchers.put(idRefString, textWatcherHolder);
        }
        return textWatcherHolder;
    }
}

