/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing;

import com.googlecode.androidannotations.annotations.Background;
import com.googlecode.androidannotations.api.BackgroundExecutor;
import com.googlecode.androidannotations.helper.APTCodeModelHelper;
import com.googlecode.androidannotations.processing.DecoratingElementProcessor;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import java.lang.annotation.Annotation;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;

public class BackgroundProcessor
implements DecoratingElementProcessor {
    private final APTCodeModelHelper helper = new APTCodeModelHelper();

    @Override
    public Class<? extends Annotation> getTarget() {
        return Background.class;
    }

    @Override
    public void process(Element element, JCodeModel codeModel, EBeanHolder holder) throws JClassAlreadyExistsException {
        ExecutableElement executableElement = (ExecutableElement)element;
        JMethod delegatingMethod = this.helper.overrideAnnotatedMethod(executableElement, holder);
        JDefinedClass anonymousRunnableClass = this.helper.createDelegatingAnonymousRunnableClass(holder, delegatingMethod);
        JClass backgroundExecutorClass = holder.refClass(BackgroundExecutor.class);
        JInvocation executeCall = backgroundExecutorClass.staticInvoke("execute").arg(JExpr._new(anonymousRunnableClass));
        delegatingMethod.body().add(executeCall);
    }
}

