/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing;

import com.googlecode.androidannotations.annotations.FragmentByTag;
import com.googlecode.androidannotations.helper.AnnotationHelper;
import com.googlecode.androidannotations.processing.DecoratingElementProcessor;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.googlecode.androidannotations.processing.EBeansHolder;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.lang.annotation.Annotation;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;

public class FragmentByTagProcessor
implements DecoratingElementProcessor {
    private final AnnotationHelper annotationHelper;

    public FragmentByTagProcessor(ProcessingEnvironment processingEnv) {
        this.annotationHelper = new AnnotationHelper(processingEnv);
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return FragmentByTag.class;
    }

    @Override
    public void process(Element element, JCodeModel codeModel, EBeanHolder holder) {
        JVar tagParam;
        JMethod findFragmentByTag;
        TypeMirror nativeFragmentType;
        EBeansHolder.Classes classes = holder.classes();
        String fieldName = element.getSimpleName().toString();
        TypeMirror elementType = element.asType();
        String typeQualifiedName = ((Object)elementType).toString();
        FragmentByTag annotation = element.getAnnotation(FragmentByTag.class);
        String tagValue = annotation.value();
        if (tagValue.equals("")) {
            tagValue = fieldName;
        }
        if (this.annotationHelper.isSubtype(elementType, nativeFragmentType = this.annotationHelper.typeElementFromQualifiedName("android.app.Fragment").asType())) {
            findFragmentByTag = null;
            if (holder.findNativeFragmentByTag == null) {
                holder.findNativeFragmentByTag = holder.generatedClass.method(4, classes.FRAGMENT, "findNativeFragmentByTag");
                tagParam = holder.findNativeFragmentByTag.param(classes.STRING, "tag");
                holder.findNativeFragmentByTag.javadoc().add("You should check that context is an activity before calling this method");
                JBlock body = holder.findNativeFragmentByTag.body();
                JVar activityVar = body.decl(classes.ACTIVITY, "activity_", JExpr.cast(classes.ACTIVITY, holder.contextRef));
                body._return(activityVar.invoke("getFragmentManager").invoke("findFragmentByTag").arg(tagParam));
            }
            findFragmentByTag = holder.findNativeFragmentByTag;
        } else {
            if (holder.findSupportFragmentByTag == null) {
                holder.findSupportFragmentByTag = holder.generatedClass.method(4, classes.SUPPORT_V4_FRAGMENT, "findSupportFragmentByTag");
                tagParam = holder.findSupportFragmentByTag.param(classes.STRING, "tag");
                JBlock body = holder.findSupportFragmentByTag.body();
                body._if(holder.contextRef._instanceof(classes.FRAGMENT_ACTIVITY).not())._then()._return(JExpr._null());
                JVar activityVar = body.decl(classes.FRAGMENT_ACTIVITY, "activity_", JExpr.cast(classes.FRAGMENT_ACTIVITY, holder.contextRef));
                body._return(activityVar.invoke("getSupportFragmentManager").invoke("findFragmentByTag").arg(tagParam));
            }
            findFragmentByTag = holder.findSupportFragmentByTag;
        }
        JBlock methodBody = holder.afterSetContentView.body();
        methodBody.assign(JExpr.ref(fieldName), JExpr.cast(holder.refClass(typeQualifiedName), JExpr.invoke(findFragmentByTag).arg(JExpr.lit(tagValue))));
    }
}

