/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing;

import com.googlecode.androidannotations.annotations.UiThread;
import com.googlecode.androidannotations.helper.APTCodeModelHelper;
import com.googlecode.androidannotations.processing.DecoratingElementProcessor;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import java.lang.annotation.Annotation;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;

public class UiThreadProcessor
implements DecoratingElementProcessor {
    private final APTCodeModelHelper helper = new APTCodeModelHelper();

    @Override
    public Class<? extends Annotation> getTarget() {
        return UiThread.class;
    }

    @Override
    public void process(Element element, JCodeModel codeModel, EBeanHolder holder) throws JClassAlreadyExistsException {
        ExecutableElement executableElement = (ExecutableElement)element;
        JMethod delegatingMethod = this.helper.overrideAnnotatedMethod(executableElement, holder);
        JDefinedClass anonymousRunnableClass = this.helper.createDelegatingAnonymousRunnableClass(holder, delegatingMethod);
        UiThread annotation = element.getAnnotation(UiThread.class);
        long delay = annotation.delay();
        if (holder.handler == null) {
            JClass handlerClass = holder.classes().HANDLER;
            holder.handler = holder.generatedClass.field(4, handlerClass, "handler_", (JExpression)JExpr._new(handlerClass));
        }
        if (delay == 0L) {
            delegatingMethod.body().invoke((JExpression)holder.handler, "post").arg(JExpr._new(anonymousRunnableClass));
        } else {
            delegatingMethod.body().invoke((JExpression)holder.handler, "postDelayed").arg(JExpr._new(anonymousRunnableClass)).arg(JExpr.lit(delay));
        }
    }
}

