/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.validation;

import com.googlecode.androidannotations.helper.TargetAnnotationHelper;
import com.googlecode.androidannotations.helper.ValidatorHelper;
import com.googlecode.androidannotations.model.AnnotationElements;
import com.googlecode.androidannotations.validation.ElementValidator;
import com.googlecode.androidannotations.validation.IsValid;
import java.lang.annotation.Annotation;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;

public class RunnableValidator
implements ElementValidator {
    private final Class<? extends Annotation> target;
    private ValidatorHelper validatorHelper;

    public RunnableValidator(Class<? extends Annotation> target, ProcessingEnvironment processingEnv) {
        this.target = target;
        TargetAnnotationHelper annotationHelper = new TargetAnnotationHelper(processingEnv, this.getTarget());
        this.validatorHelper = new ValidatorHelper(annotationHelper);
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return this.target;
    }

    @Override
    public boolean validate(Element element, AnnotationElements validatedElements) {
        IsValid valid = new IsValid();
        this.validatorHelper.enclosingElementHasEnhancedComponentAnnotation(element, validatedElements, valid);
        ExecutableElement executableElement = (ExecutableElement)element;
        this.validatorHelper.returnTypeIsVoid(executableElement, valid);
        this.validatorHelper.isNotPrivate(element, valid);
        this.validatorHelper.doesntThrowException(executableElement, valid);
        this.validatorHelper.isNotFinal(element, valid);
        this.validatorHelper.isNotSynchronized(element, valid);
        return valid.isValid();
    }
}

