/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.helper;

import com.googlecode.androidannotations.helper.AnnotationHelper;
import com.googlecode.androidannotations.helper.HasTarget;
import java.lang.annotation.Annotation;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;

public class TargetAnnotationHelper
extends AnnotationHelper
implements HasTarget {
    private Class<? extends Annotation> target;

    public TargetAnnotationHelper(ProcessingEnvironment processingEnv, Class<? extends Annotation> target) {
        super(processingEnv);
        this.target = target;
    }

    public <T> T extractAnnotationValueParameter(Element element) {
        return this.extractAnnotationParameter(element, "value");
    }

    public <T> T extractAnnotationParameter(Element element, String methodName) {
        return this.extractAnnotationParameter(element, this.target, methodName);
    }

    public DeclaredType extractAnnotationClassParameter(Element element) {
        return this.extractAnnotationClassParameter(element, this.target);
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return this.target;
    }

    public String actionName() {
        return this.actionName(this.target);
    }

    public static String annotationName(Class<? extends Annotation> annotationClass) {
        return "@" + annotationClass.getSimpleName();
    }

    public String annotationName() {
        return TargetAnnotationHelper.annotationName(this.target);
    }

    public void printAnnotationError(Element annotatedElement, String message) {
        this.printAnnotationError(annotatedElement, this.target, String.format(message, this.annotationName()));
    }

    public void printAnnotationWarning(Element annotatedElement, String message) {
        this.printAnnotationWarning(annotatedElement, this.target, String.format(message, this.annotationName()));
    }
}

