/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Messager;
import javax.tools.Diagnostic;

public class TimeStats {
    private final Map<String, Long> measures = new HashMap<String, Long>();
    private final List<Duration> durations = new ArrayList<Duration>();
    private Messager messager;

    public void start(String key) {
        long start = System.currentTimeMillis();
        this.measures.put(key, start);
    }

    public void stop(String key) {
        Long start = this.measures.remove(key);
        if (start != null) {
            long end = System.currentTimeMillis();
            long duration = end - start;
            this.durations.add(new Duration(key, duration));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Time measurements: ");
        Collections.sort(this.durations);
        for (Duration duration : this.durations) {
            sb.append("[").append(duration.key).append(" = ").append(duration.durationInMs).append(" ms], ");
        }
        return sb.toString();
    }

    public void logStats() {
        if (this.messager != null) {
            this.messager.printMessage(Diagnostic.Kind.NOTE, this.toString());
        }
    }

    public void setMessager(Messager messager) {
        this.messager = messager;
    }

    public void clear() {
        this.measures.clear();
        this.durations.clear();
    }

    private static class Duration
    implements Comparable<Duration> {
        public final String key;
        public final long durationInMs;

        public Duration(String key, long durationInMs) {
            this.key = key;
            this.durationInMs = durationInMs;
        }

        @Override
        public int compareTo(Duration o) {
            return (int)(o.durationInMs - this.durationInMs);
        }
    }
}

