/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing;

import com.googlecode.androidannotations.helper.APTCodeModelHelper;
import com.googlecode.androidannotations.helper.OnSeekBarChangeListenerHelper;
import com.googlecode.androidannotations.processing.DecoratingElementProcessor;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.googlecode.androidannotations.processing.OnSeekBarChangeListenerHolder;
import com.googlecode.androidannotations.rclass.IRClass;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;

public abstract class AbstractTrackingTouchProcessor
implements DecoratingElementProcessor {
    private final OnSeekBarChangeListenerHelper helper;
    private final APTCodeModelHelper codeModelHelper = new APTCodeModelHelper();

    public AbstractTrackingTouchProcessor(ProcessingEnvironment processingEnv, IRClass rClass) {
        this.helper = new OnSeekBarChangeListenerHelper(processingEnv, this.getTarget(), rClass, this.codeModelHelper);
    }

    @Override
    public void process(Element element, JCodeModel codeModel, EBeanHolder holder) {
        String methodName = element.getSimpleName().toString();
        List<JFieldRef> idsRefs = this.helper.extractAnnotationFieldRefs(holder, element, IRClass.Res.ID, true);
        for (JFieldRef idRef : idsRefs) {
            OnSeekBarChangeListenerHolder onSeekBarChangeListenerHolder = this.helper.getOrCreateListener(codeModel, holder, idRef);
            JMethod methodToCall = this.getMethodToCall(onSeekBarChangeListenerHolder);
            JBlock previousBody = this.codeModelHelper.removeBody(methodToCall);
            JBlock methodBody = methodToCall.body();
            methodBody.add(previousBody);
            JFieldRef activityRef = holder.generatedClass.staticRef("this");
            JInvocation textChangeCall = methodBody.invoke((JExpression)activityRef, methodName);
            ExecutableElement executableElement = (ExecutableElement)element;
            List<? extends VariableElement> parameters = executableElement.getParameters();
            if (parameters.size() != 1) continue;
            JVar progressParameter = this.codeModelHelper.findParameterByName(methodToCall, "seekBar");
            textChangeCall.arg(progressParameter);
        }
    }

    protected abstract JMethod getMethodToCall(OnSeekBarChangeListenerHolder var1);
}

