/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing;

import com.googlecode.androidannotations.annotations.FragmentArg;
import com.googlecode.androidannotations.helper.APTCodeModelHelper;
import com.googlecode.androidannotations.helper.AnnotationHelper;
import com.googlecode.androidannotations.helper.BundleHelper;
import com.googlecode.androidannotations.processing.DecoratingElementProcessor;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.googlecode.androidannotations.processing.EBeansHolder;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCast;
import com.sun.codemodel.JCatchBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JVar;
import java.lang.annotation.Annotation;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;

public class FragmentArgProcessor
implements DecoratingElementProcessor {
    private final APTCodeModelHelper helper = new APTCodeModelHelper();
    private final AnnotationHelper annotationHelper;

    public FragmentArgProcessor(ProcessingEnvironment processingEnv) {
        this.annotationHelper = new AnnotationHelper(processingEnv);
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return FragmentArg.class;
    }

    @Override
    public void process(Element element, JCodeModel codeModel, EBeanHolder holder) throws Exception {
        FragmentArg annotation = element.getAnnotation(FragmentArg.class);
        String argKey = annotation.value();
        String fieldName = element.getSimpleName().toString();
        if (argKey.isEmpty()) {
            argKey = fieldName;
        }
        TypeMirror elementType = element.asType();
        EBeansHolder.Classes classes = holder.classes();
        if (holder.fragmentArguments == null) {
            this.injectFragmentArguments(holder, codeModel);
        }
        JBlock ifContainsKey = holder.fragmentArgumentsNotNullBlock._if(JExpr.invoke((JExpression)holder.fragmentArguments, "containsKey").arg(argKey))._then();
        JTryBlock containsKeyTry = ifContainsKey._try();
        JFieldRef argField = JExpr.ref(fieldName);
        BundleHelper bundleHelper = new BundleHelper(this.annotationHelper, element);
        JInvocation restoreMethodCall = JExpr.invoke((JExpression)holder.fragmentArguments, bundleHelper.getMethodNameToRestore()).arg(argKey);
        if (bundleHelper.restoreCallNeedCastStatement()) {
            JClass jclass = this.helper.typeMirrorToJClass(element.asType(), holder);
            JCast castStatement = JExpr.cast(jclass, restoreMethodCall);
            containsKeyTry.body().assign(argField, castStatement);
            if (bundleHelper.restoreCallNeedsSuppressWarning() && holder.fragmentArgumentsInjectMethod.annotations().size() == 0) {
                holder.fragmentArgumentsInjectMethod.annotate(SuppressWarnings.class).param("value", "unchecked");
            }
        } else {
            containsKeyTry.body().assign(argField, restoreMethodCall);
        }
        JCatchBlock containsKeyCatch = containsKeyTry._catch(classes.CLASS_CAST_EXCEPTION);
        JVar exceptionParam = containsKeyCatch.param("e");
        JInvocation logError = classes.LOG.staticInvoke("e");
        logError.arg(holder.generatedClass.name());
        logError.arg("Could not cast argument to the expected type, the field is left to its default value");
        logError.arg(exceptionParam);
        containsKeyCatch.body().add(logError);
        JMethod method = holder.fragmentBuilderClass.method(1, holder.fragmentBuilderClass, fieldName);
        JClass paramClass = this.helper.typeMirrorToJClass(elementType, holder);
        JVar arg = method.param(paramClass, fieldName);
        method.body().invoke((JExpression)holder.fragmentArgumentsBuilderField, bundleHelper.getMethodNameToSave()).arg(argKey).arg(arg);
        method.body()._return(JExpr._this());
    }

    private void injectFragmentArguments(EBeanHolder holder, JCodeModel codeModel) {
        EBeansHolder.Classes classes = holder.classes();
        holder.fragmentArgumentsInjectMethod = holder.generatedClass.method(4, codeModel.VOID, "injectFragmentArguments_");
        this.injectArgumentsOnInit(holder, classes.INTENT, holder.fragmentArgumentsInjectMethod);
        JBlock injectArgumentsBody = holder.fragmentArgumentsInjectMethod.body();
        holder.fragmentArguments = injectArgumentsBody.decl(classes.BUNDLE, "args_");
        holder.fragmentArguments.init(JExpr.invoke("getArguments"));
        holder.fragmentArgumentsNotNullBlock = injectArgumentsBody._if(holder.fragmentArguments.ne(JExpr._null()))._then();
    }

    private void injectArgumentsOnInit(EBeanHolder holder, JClass intentClass, JMethod injectArgumentsMethod) {
        holder.init.body().invoke(injectArgumentsMethod);
    }
}

