/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing;

import com.googlecode.androidannotations.annotations.RoboGuice;
import com.googlecode.androidannotations.processing.DecoratingElementProcessor;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.googlecode.androidannotations.processing.EBeansHolder;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCast;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JVar;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;

public class RoboGuiceProcessor
implements DecoratingElementProcessor {
    @Override
    public Class<? extends Annotation> getTarget() {
        return RoboGuice.class;
    }

    @Override
    public void process(Element element, JCodeModel codeModel, EBeanHolder holder) {
        holder.generatedClass._implements(holder.classes().INJECTOR_PROVIDER);
        JFieldVar scope = this.scopeField(holder);
        JFieldVar eventManager = this.eventManagerField(holder);
        this.listenerFields(element, holder);
        this.afterSetContentView(codeModel, holder, scope, eventManager);
        this.onRestartMethod(codeModel, holder, scope, eventManager);
        this.onStartMethod(codeModel, holder, scope, eventManager);
        this.onResumeMethod(codeModel, holder, scope, eventManager);
        this.onPauseMethod(codeModel, holder, scope, eventManager);
        this.onNewIntentMethod(codeModel, holder, scope, eventManager);
        this.onStopMethod(codeModel, holder, scope, eventManager);
        this.onDestroyMethod(codeModel, holder, scope, eventManager);
        this.onConfigurationChangedMethod(codeModel, holder, scope, eventManager);
        this.onContentChangedMethod(codeModel, holder, scope, eventManager);
        this.onActivityResultMethod(codeModel, holder, scope, eventManager);
        JMethod getInjectorMethod = this.getInjectorMethod(holder);
        this.beforeCreateMethod(holder, scope, eventManager, getInjectorMethod);
    }

    private JMethod getInjectorMethod(EBeanHolder holder) {
        JMethod method = holder.generatedClass.method(1, holder.classes().INJECTOR, "getInjector");
        method.annotate(Override.class);
        JCast castApplication = JExpr.cast(holder.classes().INJECTOR_PROVIDER, JExpr.invoke("getApplication"));
        method.body()._return(castApplication.invoke("getInjector"));
        return method;
    }

    private void onRestartMethod(JCodeModel codeModel, EBeanHolder holder, JFieldVar scope, JFieldVar eventManager) {
        JMethod method = holder.generatedClass.method(1, codeModel.VOID, "onRestart");
        method.annotate(Override.class);
        JBlock body = method.body();
        body.invoke((JExpression)scope, "enter").arg(JExpr._this());
        body.invoke(JExpr._super(), method);
        this.fireEvent(holder, eventManager, body, holder.classes().ON_RESTART_EVENT, new JExpression[0]);
    }

    private void onStartMethod(JCodeModel codeModel, EBeanHolder holder, JFieldVar scope, JFieldVar eventManager) {
        JMethod method = holder.generatedClass.method(1, codeModel.VOID, "onStart");
        method.annotate(Override.class);
        JBlock body = method.body();
        body.invoke((JExpression)scope, "enter").arg(JExpr._this());
        body.invoke(JExpr._super(), method);
        this.fireEvent(holder, eventManager, body, holder.classes().ON_START_EVENT, new JExpression[0]);
    }

    private void onResumeMethod(JCodeModel codeModel, EBeanHolder holder, JFieldVar scope, JFieldVar eventManager) {
        JMethod method = holder.generatedClass.method(1, codeModel.VOID, "onResume");
        method.annotate(Override.class);
        JBlock body = method.body();
        body.invoke((JExpression)scope, "enter").arg(JExpr._this());
        body.invoke(JExpr._super(), method);
        this.fireEvent(holder, eventManager, body, holder.classes().ON_RESUME_EVENT, new JExpression[0]);
    }

    private void onPauseMethod(JCodeModel codeModel, EBeanHolder holder, JFieldVar scope, JFieldVar eventManager) {
        JMethod method = holder.generatedClass.method(1, codeModel.VOID, "onPause");
        method.annotate(Override.class);
        JBlock body = method.body();
        body.invoke(JExpr._super(), method);
        this.fireEvent(holder, eventManager, body, holder.classes().ON_PAUSE_EVENT, new JExpression[0]);
    }

    private void onNewIntentMethod(JCodeModel codeModel, EBeanHolder holder, JFieldVar scope, JFieldVar eventManager) {
        JMethod method = holder.generatedClass.method(1, codeModel.VOID, "onNewIntent");
        method.annotate(Override.class);
        JVar intent = method.param(holder.classes().INTENT, "intent");
        JBlock body = method.body();
        body.invoke(JExpr._super(), method).arg(intent);
        body.invoke((JExpression)scope, "enter").arg(JExpr._this());
        this.fireEvent(holder, eventManager, body, holder.classes().ON_NEW_INTENT_EVENT, new JExpression[0]);
    }

    private void fireEvent(EBeanHolder holder, JFieldVar eventManager, JBlock body, JClass eventClass, JExpression ... eventArguments) {
        JInvocation newEvent = JExpr._new(eventClass);
        for (JExpression eventArgument : eventArguments) {
            newEvent.arg(eventArgument);
        }
        body.invoke((JExpression)eventManager, "fire").arg(newEvent);
    }

    private void onStopMethod(JCodeModel codeModel, EBeanHolder holder, JFieldVar scope, JFieldVar eventManager) {
        JMethod method = holder.generatedClass.method(1, codeModel.VOID, "onStop");
        method.annotate(Override.class);
        JBlock body = method.body();
        body.invoke((JExpression)scope, "enter").arg(JExpr._this());
        JTryBlock tryBlock = body._try();
        this.fireEvent(holder, eventManager, tryBlock.body(), holder.classes().ON_STOP_EVENT, new JExpression[0]);
        JBlock finallyBody = tryBlock._finally();
        finallyBody.invoke((JExpression)scope, "exit").arg(JExpr._this());
        finallyBody.invoke(JExpr._super(), method);
    }

    private void onDestroyMethod(JCodeModel codeModel, EBeanHolder holder, JFieldVar scope, JFieldVar eventManager) {
        JMethod method = holder.generatedClass.method(1, codeModel.VOID, "onDestroy");
        method.annotate(Override.class);
        JBlock body = method.body();
        body.invoke((JExpression)scope, "enter").arg(JExpr._this());
        JTryBlock tryBlock = body._try();
        this.fireEvent(holder, eventManager, tryBlock.body(), holder.classes().ON_DESTROY_EVENT, new JExpression[0]);
        JBlock finallyBody = tryBlock._finally();
        finallyBody.invoke((JExpression)eventManager, "clear").arg(JExpr._this());
        finallyBody.invoke((JExpression)scope, "exit").arg(JExpr._this());
        finallyBody.invoke((JExpression)scope, "dispose").arg(JExpr._this());
        finallyBody.invoke(JExpr._super(), method);
    }

    private void onConfigurationChangedMethod(JCodeModel codeModel, EBeanHolder holder, JFieldVar scope, JFieldVar eventManager) {
        JMethod method = holder.generatedClass.method(1, codeModel.VOID, "onConfigurationChanged");
        method.annotate(Override.class);
        JClass configurationClass = holder.classes().CONFIGURATION;
        JVar newConfig = method.param(configurationClass, "newConfig");
        JBlock body = method.body();
        JVar currentConfig = body.decl(configurationClass, "currentConfig", JExpr.invoke("getResources").invoke("getConfiguration"));
        body.invoke(JExpr._super(), method).arg(newConfig);
        this.fireEvent(holder, eventManager, body, holder.classes().ON_CONFIGURATION_CHANGED_EVENT, currentConfig, newConfig);
    }

    private void onContentChangedMethod(JCodeModel codeModel, EBeanHolder holder, JFieldVar scope, JFieldVar eventManager) {
        JMethod method = holder.generatedClass.method(1, codeModel.VOID, "onContentChanged");
        method.annotate(Override.class);
        JBlock body = method.body();
        body.invoke(JExpr._super(), method);
        this.fireEvent(holder, eventManager, body, holder.classes().ON_CONTENT_CHANGED_EVENT, new JExpression[0]);
    }

    private void onActivityResultMethod(JCodeModel codeModel, EBeanHolder holder, JFieldVar scope, JFieldVar eventManager) {
        JMethod method = holder.generatedClass.method(1, codeModel.VOID, "onActivityResult");
        method.annotate(Override.class);
        JVar requestCode = method.param(codeModel.INT, "requestCode");
        JVar resultCode = method.param(codeModel.INT, "resultCode");
        JVar data = method.param(holder.classes().INTENT, "data");
        JBlock body = method.body();
        body.invoke(JExpr._super(), method).arg(requestCode).arg(resultCode).arg(data);
        body.invoke((JExpression)scope, "enter").arg(JExpr._this());
        JTryBlock tryBlock = body._try();
        this.fireEvent(holder, eventManager, tryBlock.body(), holder.classes().ON_ACTIVITY_RESULT_EVENT, requestCode, resultCode, data);
        JBlock finallyBody = tryBlock._finally();
        finallyBody.invoke((JExpression)scope, "exit").arg(JExpr._this());
    }

    private void afterSetContentView(JCodeModel codeModel, EBeanHolder holder, JFieldVar scope, JFieldVar eventManager) {
        JBlock afterSetContentViewBody = holder.afterSetContentView.body();
        afterSetContentViewBody.invoke((JExpression)scope, "injectViews");
        this.fireEvent(holder, eventManager, afterSetContentViewBody, holder.classes().ON_CONTENT_VIEW_AVAILABLE_EVENT, new JExpression[0]);
    }

    private JFieldVar eventManagerField(EBeanHolder holder) {
        JFieldVar eventManager = holder.generatedClass.field(4, holder.classes().EVENT_MANAGER, "eventManager_");
        return eventManager;
    }

    private JFieldVar scopeField(EBeanHolder holder) {
        JFieldVar scope = holder.generatedClass.field(4, holder.classes().CONTEXT_SCOPE, "scope_");
        return scope;
    }

    private void listenerFields(Element element, EBeanHolder holder) {
        List<String> listenerClasses = this.extractListenerClasses(element);
        if (listenerClasses.size() > 0) {
            int i = 1;
            for (String listenerClassName : listenerClasses) {
                JClass listenerClass = holder.refClass(listenerClassName);
                JFieldVar listener = holder.generatedClass.field(4, listenerClass, "listener" + i + "_");
                listener.annotate(SuppressWarnings.class).param("value", "unused");
                listener.annotate(holder.classes().INJECT);
                ++i;
            }
        }
    }

    private List<String> extractListenerClasses(Element activityElement) {
        List<? extends AnnotationMirror> annotationMirrors = activityElement.getAnnotationMirrors();
        String annotationName = RoboGuice.class.getName();
        AnnotationValue action = null;
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!annotationName.equals(annotationMirror.getAnnotationType().toString())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!"value".equals(entry.getKey().getSimpleName().toString())) continue;
                action = entry.getValue();
                List values = (List)action.getValue();
                ArrayList<String> listenerClasses = new ArrayList<String>();
                for (Object value : values) {
                    listenerClasses.add(value.toString());
                }
                return listenerClasses;
            }
        }
        return new ArrayList<String>(0);
    }

    private void beforeCreateMethod(EBeanHolder holder, JFieldVar scope, JFieldVar eventManager, JMethod getInjector) {
        EBeansHolder.Classes classes = holder.classes();
        JBlock body = holder.init.body();
        JVar injector = body.decl(classes.INJECTOR, "injector_", JExpr.invoke(getInjector));
        body.assign(scope, JExpr.invoke((JExpression)injector, "getInstance").arg(classes.CONTEXT_SCOPE.dotclass()));
        body.invoke((JExpression)scope, "enter").arg(JExpr._this());
        body.invoke((JExpression)injector, "injectMembers").arg(JExpr._this());
        body.assign(eventManager, JExpr.invoke((JExpression)injector, "getInstance").arg(classes.EVENT_MANAGER.dotclass()));
        this.fireEvent(holder, eventManager, body, holder.classes().ON_CREATE_EVENT, holder.beforeCreateSavedInstanceStateParam);
    }
}

